#include <stdio.h>
#include <string.h>
#include <stdlib.h>		/* for strtol() */

#include "gm_internal.h"

gm_port_t *g_port = 0;

static
void
usage (void)
{
  printf("\nusage: gm_simpleroute [-B board] [loopback]>\n");

  printf("-B #   specifies board number (default = 0)\n");
  printf("<loopback> specifies setting a route for a loopback cable\n");
  printf("\n");
  gm_exit(GM_FAILURE);
}

static
void
exit_if_error (const char *msg, gm_status_t status)
{
  if (status != GM_SUCCESS)
    {
      gm_perror (msg, status);
      gm_exit (status);
    }
}

static int
gm_simpleroute (int argc, char *argv[])
{
  gm_status_t status;
  unsigned nodeid;
  int i;
  unsigned char uniqueboard[6],unique_byid[6];
  unsigned char ether[2][6];
  unsigned char route[1]={0x80};
  int routelen = 1;
  int portid = 1;
  int set_loopback = 0;
  int board_id = 0;
  int peerid = 1;
  int thisid = 1;
  int back = 0;
  char *master, *slave = 0;

  master = "localhost";


    for (argc--, argv++; argc; argc--, argv++) {
        if (strcmp(*argv, "-B") == 0) {
            argc--, argv++;
            if (!argc) {
                printf("Board number expected after '-B'.\n");
                usage();
            }
            if (sscanf(*argv, "%i", &board_id) != 1
                    || board_id < 0
                    || board_id > 1000) {
                printf("bad board number: %d\n", board_id);
                usage();
            }
            continue;
        }
        else if ((strcmp(*argv, "loopback") == 0) || 
		 (strcmp(*argv, "loop") == 0) ||
		 (strcmp(*argv, "l") == 0) ||
		 (strcmp(*argv, "-loopback") == 0) ||
		 (strcmp(*argv, "--loopback") == 0) ||
		 (strcmp(*argv, "-loop") == 0) ||
		 (strcmp(*argv, "--loop") == 0)) {
	    set_loopback = 1;
            continue;
        }
    }

  if (set_loopback) {
    route[0] = 0;
    routelen = 0;
    fprintf(stderr,"setting loopback route\n");
  } else if (argc == 5) {
    route[0] = 0;
    routelen = 0;
    master = argv[1];
    slave = argv[3];
    for (i=0;i<6;i++) {
      ether[0][i] = (unsigned char)strtol(strtok(i==0?argv[2]:0,":"),NULL,16);
    }
    printf("master:");
    for(i=0;i<6;i++)
      printf("%02x:",ether[0][i]);
    for (i=0;i<6;i++) {
      ether[1][i] = (unsigned char)strtol(strtok(i==0?argv[4]:0,":"),NULL,16);
    }
    printf("slave:");
    for(i=0;i<6;i++)
      printf("%02x:",ether[1][i]);
    printf("\n");
    back = 1;
    peerid = 2;
    fprintf(stderr,"setting back-to-back route\n");
  } else {
    fprintf(stderr,"setting switch round-trip route\n");
  }

  status = _gm_open_common(&g_port, board_id, portid,
                   "small-gm-test", GM_API_VERSION_1_0);
  if (status != GM_SUCCESS)
    gm_perror ("open failed", status), gm_exit (status);
  status = gm_get_node_id(g_port,&nodeid);
  if (status != GM_SUCCESS) {
    if (status == GM_NODE_ID_NOT_YET_SET)
      nodeid = GM_NO_SUCH_NODE_ID;
    else
      gm_perror ("could not get node ID", status), gm_exit (status);
  }
  printf("this node id = %d\n",nodeid);
  status = gm_get_unique_board_id (g_port, (char*)uniqueboard);
  if (status != GM_SUCCESS)
    gm_perror ("could not get unique board id", status), gm_exit (status);
  status = gm_node_id_to_unique_id (g_port, nodeid, (char*)unique_byid);
  if (status != GM_SUCCESS) {
    gm_perror ("could not convert node ID to unique ID", status);
    gm_exit (status);
  }
  printf("uniqueid by node_id_to_unique_id =");
  for(i=0;i<6;i++)
    printf("%02x:",unique_byid[i]);
  printf("\n");
  printf("uniqueid=");
  for(i=0;i<6;i++)
    printf("%02x:",uniqueboard[i]);
  printf("\n");
  if (back == 1) {
    if (memcmp(ether[0],uniqueboard,6) == 0)
      thisid = 1;
    else if (memcmp(ether[1],uniqueboard,6) == 0)
      thisid = 2;
    else
      gm_perror ("obscure error", GM_FAILURE), gm_exit (GM_FAILURE);
  }
  status = _gm_set_node_id (g_port, thisid);
  status = _gm_set_unique_id (g_port, 1, (char *)uniqueboard);
  exit_if_error ("could not set unique ID 1", status);

  exit_if_error ("could not set node ID", status);
  if (back) {
    status = _gm_set_unique_id (g_port, 1, (char *)ether[0]);
    exit_if_error ("could not set unique ID 1", status);
    status = _gm_set_unique_id (g_port, 2, (char *)ether[1]);
    exit_if_error ("could not set unique ID 2", status);
  }
  status = _gm_set_host_name (g_port, 1, master);
  exit_if_error ("could not set host name 1", status);
  if (back) {
    status = _gm_set_host_name (g_port, 2, slave);
    exit_if_error ("could not set host name 2", status);
  }
  status = _gm_set_route (g_port, peerid, routelen, (char *)route);
  exit_if_error ("could not set route to peer", status);

  if (g_port) {
    gm_close (g_port);
  }
  return(status);
}

/****************************************************************
 * entry point
 ****************************************************************/

#define GM_MAIN gm_simpleroute
#include "gm_main.h"
