/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997, 1998, 1999 by Myricom, Inc.                 *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

/* author: finucane@myri.com */

#ifdef __STDC__
#if GM_OS_VXWORKS
#include "vxWorks.h"
#endif  /* GM_OS_VXWOKRS */
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#ifdef HAVE_UNISTD_H
#include "unistd.h"
#endif

#include "gm_internal.h"

#define num_elements(e)(sizeof(e)/sizeof(e[0]))

#include "gm.h"
typedef struct speed_t
{
  int clock;
  int speed;
  int mbyte_per_sec;
} speed_t;

static speed_t speeds [] =
{
  {
    0x606c81,  1280, 160
  },

  {
    0x61e80e,  2000, 250
  },
  
  {
    0x60a003,  2200, 275
  },
  
  {
    0x612006,  2400, 300
  },
 
  {
    0x606c01,  2560, 320
  },
 
};


static int dl_clock (struct gm_port*port, long int c)
{
  return
    !_gm_cop_wakeup  (port) &&
    !_gm_cop_send (port, 0x21) &&
    !_gm_cop_send (port, (c >> 16) & 0xFF) &&
    !_gm_cop_send (port, (c >> 8) & 0xFF) &&
    !_gm_cop_send (port, c & 0xFF) &&
    !_gm_cop_end (port);
}

static int do_bitwr (struct gm_port*port, int addr, int bitinfo)
{
  return
    !_gm_cop_wakeup  (port) &&
    !_gm_cop_send (port, 0x2F) &&
    !_gm_cop_send (port, addr) &&
    !_gm_cop_send (port, bitinfo & 0xF7) &&
    !_gm_cop_end (port);
}

static void usage ()
{
  int i;
  
  printf ("gm_set_speed [--unit <unit>] [--speed <speed>]\n");
  printf ("where speed is one of:\n");

  for (i = 0; i < 2 /*num_elements (speeds)*/; i++)
    printf ("%d\n", speeds [i].speed);
  
  exit (1971);
}

static int gm_set_speed (int argc, char *argv[])
{
  struct gm_port*port;
  
  int i;
  int unit = 0;
  int speed = 2000;

  for (i = 1; i < argc; i++)
  {
    if (!strcmp (argv [i], "--unit"))
    {
      if (++i == argc)
      {
	printf ("expected unit number");
	usage ();
      }
      unit = atoi (argv [i]);
    }
    else if (!strcmp (argv [i], "--speed"))
    {
      if (++i == argc)
	printf ("expected speed");
      speed = atoi (argv [i]);
    }
    else
    {
      printf ("bad option %s\n", argv [i]);
      usage ();
    }
  }

  for (i = 0; i < num_elements (speeds); i++)
    if (speeds [i].speed == speed)
      break;

  if (i == num_elements (speeds))
  {
    printf ("%d is a bad speed.\n", speed);
    usage ();  
  }

  if (_gm_mapper_open (&port, unit, GM_API_VERSION_1_0) != GM_SUCCESS)
  {
    printf ("_gm_mapper_open failed\n");
    exit (1);
  }
  
  printf("Setting link speed on unit=%d to %d\n",unit,speed);
  if (!dl_clock (port, 0x1e0000) || !dl_clock (port, speeds [i].clock))
    printf ("dl_clock failed\n");

  gm_close(port);

  return(0);
}

#define GM_MAIN gm_set_speed
#include "gm_main.h"
