/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include "gm_internal.h"

#define REPORT_PROGRESS	0
#define TEST_PRIORITY	GM_LOW_PRIORITY
#define MIN_TEST_SIZE	1
/*#define MAX_TEST_SIZE	16*/
#define MAX_TEST_SIZE	16
#define TEST_TIME	5
#define TEST_MESSAGE_CNT	1

enum test_message_types {
  test_bogus_type = 0,
  test_ping_type
};

typedef struct test_message
{
  gm_u32_t type;
  gm_u8_t size;
  char     payload[1];
} test_message_t;

				/* Define the type of message we will
                                   be sending and receiving. */
typedef struct chainable_test_message
{
				/* Use the 8 bytes at the head of the
                                   message for user data that will not
                                   be sent over the network. */
  struct chainable_test_message *next;
  gm_u8_t  reserved[4];
  test_message_t message;

} chainable_test_message_t;

chainable_test_message_t *free_send_messages[32];

static /* inline  */
void
free_send_message (test_message_t *p)
{
  chainable_test_message_t *ctp = (chainable_test_message_t *)((char *)p-8);

  chainable_test_message_t *x;

/* FIXME */
  x = free_send_messages[p->size];
  ctp->next = x;

  free_send_messages[p->size] = ctp;
}

static
void *
my_dma_malloc (gm_port_t *p, unsigned length)
{
  int i;
  void *ret;

  /* Try to allocate a buffer from the
     existing memory allocation
     zones. */
  for (i=p->num_zones-1; i>=0; i--)
    {
      ret = gm_zone_malloc (p->dma_zone[i], length);
      if (ret)
	  return (ret);
    }
  assert (i == -1);
				/* Could not allocate the buffer from
                                   the existing zones */

				/* First, check if the requested
                                   length is too large to possibly be
                                   allocated, even if we fully expand
                                   the copy block. */
  /*if (length > p->mappings->copy_block.len/2)
      return NULL;
      */			/* Try to create bigger zones until
                                   the alloc succeeds or we cannot
                                   create a bigger zone.  */
  do
    {
      void *addr;
      unsigned alloc_len;

      alloc_len = (p->alloced_dma_mem_len
		   ? (unsigned) p->alloced_dma_mem_len
		   : (unsigned) GM_PAGE_LEN);
      assert (GM_POWER_OF_TWO (alloc_len));

      /*
      addr = mmap (0, alloc_len, PROT_READ | PROT_WRITE, MAP_SHARED, p->fd,
		   p->mappings->copy_block.offset + p->alloced_dma_mem_len);
		   */

      addr = gm_malloc (alloc_len);

      if (!addr)
	  return NULL;
      p->dma_zone[p->num_zones] = gm_zone_create_zone (addr, alloc_len);
      p->num_zones++;
      p->alloced_dma_mem_len += alloc_len;
      ret = gm_zone_malloc (p->dma_zone[p->num_zones-1], length);
    }
  while (!ret);

  return ret;
}

static
void *
my_dma_calloc (gm_port_t *p, unsigned count, unsigned length)
{
  void *ret;
  length *= count;
  ret = my_dma_malloc (p, length);
  if (ret)
    gm_bzero (ret, length);
  return ret;
}

gm_port_t port;

static
void
test_init (int *argc, char ***argv)
{
  int i, size;
  unsigned int j;
  GM_PARAMETER_MAY_BE_UNUSED (argc);
  GM_PARAMETER_MAY_BE_UNUSED (argv);
  
  for (i=0; i<32; i++) {
    free_send_messages[i] = 0;
  }  
  
  for (size = MIN_TEST_SIZE; size <= MAX_TEST_SIZE; size++)
    {
      int tokens_of_size;
      if (size<8)
	{
	  tokens_of_size = 512/(1<<size);
	}
      else
	{
	  tokens_of_size = 2;
	}

      printf ("size = %d, tokens_of_size = %d\n", size, tokens_of_size);
      
      for (i = 0; i < tokens_of_size; i++)
	{
	  chainable_test_message_t *ctp;
	  
	  printf ("about to allocate1 %d\n", i);
	  
	  ctp = (chainable_test_message_t *)
	    my_dma_calloc (&port, 1, (unsigned) gm_max_length_for_size(size)+8);
	  assert (ctp != 0);
      
	  ctp->message.type = test_ping_type;
	  ctp->message.size = size;
	  
				/* Make sure message is aligned. */
	  assert (GM_DMA_ALIGNED (ctp));

	  printf ("about to allocate2 %d\n", i);
	  
				/* Alloc send messages. */
	  ctp = ( (chainable_test_message_t *)
		  my_dma_calloc (&port, 1, (unsigned) gm_max_length_for_size (size)+8));

				/* Fill the message with 0xaa */
	  assert (ctp != 0);
	  assert (GM_DMA_ALIGNED (ctp));

	  for (j = 0; j < gm_max_length_for_size (size)+8; j++)
	    {
	      ((char *)ctp)[j] = '\xAA';
	    }
	  
	  ctp->next = 0;
	  ctp->message.size = size;
	  ctp->message.type = test_ping_type;
	  free_send_message (&ctp->message);
	}
    }

  printf ("done initializing\n");
}

int
main (int argc, char **argv)
{
  port.num_zones = 0;

  test_init (&argc, &argv);
  
  return 0;
}
