/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation			 *
 * Copyright (c) 1999 by Myricom, Inc.					 *
 * All rights reserved.	 See the file `COPYING' for copyright notice.	 *
 *************************************************************************/

/* author: glenn@myri.com */

/* This file arranges for the entry point GM_MAIN to be called.  The
   user must '#define GM_MAIN' to be the desired entry point before including
   this file. */

#ifndef GM_MAIN
#error GM_MAIN is not defined to be the name of the entry point function.
#endif

#include "gm_config.h"
#include "gm_cpp.h"

static int GM_MAIN (int argc, char *argv[]);

/****************************************************************
 * Conventional C entry point.
 ****************************************************************/

#if !GM_OS_VXWORKS

int
main (int argc, char **argv, char **env)
{
  GM_PARAMETER_MAY_BE_UNUSED (env);
  
  /* The user should supply a matching entry point. */

  return GM_MAIN (argc, argv);
}

/****************************************************************
 * VxWorks ad-hoc entry point
 ****************************************************************/

#else /* GM_OS_VXWORKS */


/* VxWorks wants the following, which we provide here:

   VXMAIN: A unique name to give the VxWorks entry point.

   VXNAME: The argv[0] to pass to main. */


/* `GM_PREPEND_MAIN(foo)' ->  `main_foo'  I.e.: it prepends `main_' */
#define _GM_PREPEND_MAIN(x) main_ ## x
#define  GM_PREPEND_MAIN(x) _GM_PREPEND_MAIN(x)

/* `GM_PREPEND_VXWORKS(foo)' ->  `vxworks_foo'  I.e.: it prepends `vxworks_' */
#define _GM_PREPEND_VXWORKS(x) vxworks_ ## x
#define  GM_PREPEND_VXWORKS(x) _GM_PREPEND_VXWORKS(x)

/* `GM_STRINGIFY(x)' -> `"foo"' */
/* now defined in gm_cpp.h */
/*#define _GM_STRINGIFY(x) #x*/
/*#define GM_STRINGIFY(x) _GM_STRINGIFY(x)*/

/* This should do something like `#define VXMAIN main_gm_allsize' */
#define VXMAIN GM_PREPEND_VXWORKS ( GM_MAIN )

/* This should do something like `#define VXMAIN "gm_allsize"' */
#define VXNAME GM_STRINGIFY ( VXMAIN )

/* This should do something like `#define VXMAIN main_gm_allsize' */
#define MAINNAME GM_PREPEND_MAIN ( GM_MAIN )


#include <setjmp.h>
static jmp_buf gm_vxworks_fake_exit_env;

GM_ENTRY_POINT void
gm_exit (gm_status_t status)
{
  printf ("faking gm_exit in VxWorks\n");
  longjmp (gm_vxworks_fake_exit_env, status ? status : GM_FAILURE);
}



/* This should define the entry function like 'int main_gm_allsize (...)' */
#include "vxmain.h"
int
MAINNAME (int argc, char **argv)
{
  int error;

  /* Arrange for gm_exit() to work safely on VxWorks. */

  error = setjmp (gm_vxworks_fake_exit_env);
  if (error)
    return error;

  /* Call the real entry point */

  return GM_MAIN (argc, argv);
}

#endif /* GM_OS_VXWORKS */

/*
  This file uses GM standard indentation:

  Local Variables:
  c-file-style:"gnu"
  tab-width:8
  c-backslash-column:72
  End:
*/
