/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

/*************************************************************************/
/********* WARNING - this is unsupported code ****************************/
/*************************************************************************/

#include <stdio.h>
#include <stdlib.h>
;

#if defined (sparc_sunOS)
extern int puts (const char *s);
#elif defined (sparc_solaris)
extern int puts (const char *s);
#endif

long random ();

enum test_message_types {
  test_bogus_type = 0,
  test_ping_type,
};

#include "gm.h"

#define REPORT_PROGRESS	0
#define TEST_PRIORITY	GM_LOW_PRIORITY
#define MIN_TEST_SIZE	4
//#define MAX_TEST_SIZE	16
#define MAX_TEST_SIZE	12
#define TEST_TIME	1
#define TEST_MESSAGE_CNT	1

#define MIN_LENGTH 1
#define MAX_LENGTH 10000

typedef struct test_message
{
  gm_u32_n_t type;
  gm_u8_n_t size;
  gm_u8_n_t payload[1];
} test_message_t;

				/* Define the type of message we will
                                   be sending and receiving. */
typedef struct chainable_test_message
{
				/* Use the 8 bytes at the head of the
                                   message for user data that will not
                                   be sent over the network. */
  struct chainable_test_message *next;
  gm_u8_t  reserved[4];
  test_message_t message;

} chainable_test_message_t;

chainable_test_message_t *free_send_messages[32];

static /* inline  */
void
free_send_message (test_message_t *p)
{
  chainable_test_message_t *ctp = (chainable_test_message_t *)((char *)p-8);

  chainable_test_message_t *x;

  // FIXME
  x = free_send_messages[p->size];
  ctp->next = x;

  free_send_messages[p->size] = ctp;
}

gm_port_t port;

void
test_init (int *argc, char ***argv)
{
  int i, size, j;
  unsigned port_id = 2;
  gm_status_t status;
  
  if (*argc > 1)
    port_id = atoi ((*argv)[1]);

  for (i=0; i<32; i++) {
    free_send_messages[i] = 0;
  }  
  
				/* Initialize GM */
  status = gm_open (&port, 0, port_id, "latency test");
  if (status != GM_SUCCESS)
    {
      gm_perror ("could not open GM port", status);
      gm_exit (status);
    }

  printf ("GM is initialized.\n\n");
  
  status = gm_set_acceptable_sizes (&port, GM_LOW_PRIORITY,
				    ((1<<(MAX_TEST_SIZE+1))-1)
				    ^((1<<MIN_TEST_SIZE)-1));
  if (status != GM_SUCCESS)
    {
      gm_perror ("could not set GM acceptable sizes", status);
      gm_exit (status);
    }

				/* Let GM manage the send tokens */
  gm_free_send_tokens (&port, GM_LOW_PRIORITY, GM_NUM_SEND_TOKENS/2);
  gm_free_send_tokens (&port, GM_HIGH_PRIORITY, GM_NUM_SEND_TOKENS/2);

				/* Setup recv tokens */
  for (size = MIN_TEST_SIZE; size <= MAX_TEST_SIZE; size++)
    {
      int tokens_of_size;
      if (size<8)
	{
	  tokens_of_size = 512/(1<<size);
	}
      else
	{
	  tokens_of_size = 2;
	}

      printf ("size = %d, tokens_of_size = %d\n", size, tokens_of_size);
      printf ("length = %d, allocating %d bytes per message\n",
	      gm_max_length_for_size(size),
	      gm_max_length_for_size(size)+8);
      
      for (i = 0; i < tokens_of_size; i++)
	{
	  chainable_test_message_t *ctp;
	  
	  ctp = (chainable_test_message_t *)
	    gm_dma_calloc (&port, 1, gm_max_length_for_size(size)+8);
	  gm_always_assert (ctp != 0);
      
	  ctp->message.type = test_ping_type;
	  ctp->message.size = size;
	  
				/* Make sure message is aligned. */
	  gm_always_assert (GM_DMA_ALIGNED (ctp));
	  gm_provide_receive_buffer (&port, &ctp->message, size, TEST_PRIORITY);

				/* Alloc send messages. */
	  ctp = ( (chainable_test_message_t *)
		  gm_dma_calloc (&port, 1, gm_max_length_for_size (size)+8));

				/* Fill the message with 0xaa */
	  gm_always_assert (ctp != 0);
	  gm_always_assert (GM_DMA_ALIGNED (ctp));

	  for (j = 0; j < gm_max_length_for_size (size)+8; j++)
	    {
	      ((char *)ctp)[j] = 0xaa;
	    }
	  
	  ctp->next = 0;
	  ctp->message.size = size;
	  ctp->message.type = test_ping_type;
	  free_send_message (&ctp->message);
	}
    }

  printf ("done initializing\n");
}

int
gm_latency (int argc, char **argv)
{
  unsigned int pending_send_count = 1, size = MIN_TEST_SIZE;
  unsigned int recv_cnt = 0;
  gm_recv_event_t *event;
      
  test_init (&argc, &argv);
  
  pending_send_count = 1;

  printf ("starting\n");
  
  gm_set_alarm (&port, TEST_TIME * 1000 * 1000); 

  goto try_send;

  while (1)
    {
      event = gm_receive (&port);
      switch (gm_recv_event_type (event))
	{
	case GM_SENT_EVENT:
	  {
	    void **pp;

	    pp = (void **) gm_ntohl ((long) event->sent.message_list);
	    do
	      {
		*pp = gm_ntohl (*pp);
		free_send_message (*pp);
		gm_free_send_token (&port, TEST_PRIORITY);
	      }
	    while (*++pp);
	    goto try_send;
	  }

	case GM_PEER_RECV_EVENT:
	case GM_FAST_PEER_RECV_EVENT:

				/* Recycle the receive buffer. */
	  gm_provide_receive_buffer (&port, event->recv.buffer,
				     event->recv.size, TEST_PRIORITY);

	  recv_cnt++;

				/* Queue a send. */
	  pending_send_count++;

	  goto try_send;
	    
	case GM_NO_RECV_EVENT:
	try_send:	
				/* Enqueue any pending send */
	  while (pending_send_count && free_send_messages[size]
		 && gm_alloc_send_token (&port, TEST_PRIORITY))
	    {
	      test_message_t *pktptr = &free_send_messages[size]->message;

	      gm_send (&port, &free_send_messages[size]->message, size,
		       gm_max_length_for_size (size), TEST_PRIORITY,
		       port.this_node_id, port.id);
	      free_send_messages[size] = free_send_messages[size]->next;
	      pending_send_count--;
	    }
	  break;
	
	case GM_ALARM_EVENT:
	  printf ("Port %d received %d messages of size %d in %d seconds.\n",
		  port.id, recv_cnt, size, TEST_TIME);

	  printf ("round trip latency = %f us\n\n",
		  (double)TEST_TIME*1e6 / recv_cnt);
		  
	  recv_cnt = 0;
	  size++;
	  if (size > MAX_TEST_SIZE)
	    {
	      size--;
	      goto done;
	    }
	  gm_set_alarm (&port, TEST_TIME * 1000 * 1000);
	  break;

	case GM_HIGH_RECV_EVENT:
	case GM_FAST_HIGH_RECV_EVENT:
	case GM_HIGH_PEER_RECV_EVENT:
	case GM_FAST_HIGH_PEER_RECV_EVENT:
	  printf ("oops: bogus event\n");
	  
	  abort ();
	  
	default:
	  printf ("oops: unknown event\n");
	  gm_unknown (&port, event);
	}
    }

done:

  printf ("done.\n");
  
  gm_close (&port);
  printf ("GM deinitialized.\n");

  return 0;
}

#define GM_MAIN gm_latency
#include "gm_main.h"
