/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1999 by Myricom, Inc.                                   *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>


/* This program uses undocumented software interfaces that are not
   intended for use in code written outside Myricom.  Hence the
   following undocumented includes. */

#include "gm_internal.h"
#include "gm_enable_error_counters.h"
#include "gm_enable_debug_counters.h"
#include "gm_enable_packet_counters.h"

/* this 1024 was hard-coded in drivers/gm.c */
/* don't really want to get all the data from a card with 2Meg+ */
#define MY_MAX_NODE	(3*1024)

unsigned int space[(sizeof(struct gm_lanai_globals) +
		       ((MY_MAX_NODE+1) * sizeof(struct gm_connection))) / sizeof(int)];

struct gm_lanai_globals *globals = (struct gm_lanai_globals *) space;
gm_u64_t current_rtc;

gm_port_t *port;

extern int atoi(const char *);

static int
gm_counters(int argc, char **argv)
{
	int board_num = 0, port_num = 0;
	int i;
	int length;
	gm_status_t status;

	for (i = 1; i < argc; i++) {
		if (strcmp(argv[i], "-B") == 0) {
			if (i + 1 >= argc) {
				printf("Board number expected after '-B'.\n");
				gm_exit(GM_INVALID_PARAMETER);
			}
			board_num = atoi(argv[++i]);
			if (board_num < 0) {
				printf("bad board number: %d\n", board_num);
				gm_exit(GM_INVALID_PARAMETER);
			}
			continue;
		}
		if (strcmp(argv[i], "-p") == 0) {
			if (i + 1 >= argc) {
				printf("Port number expected after '-p'.\n");
				gm_exit(GM_INVALID_PARAMETER);
			}
			port_num = atoi(argv[++i]);
			if (port_num < 0) {
				printf("bad port number: %d\n", port_num);
				gm_exit(GM_INVALID_PARAMETER);
			}
			continue;
		}
	}

	status = _gm_open_common(&port, board_num, port_num, "gm_debug",
							 GM_API_VERSION_1_0);
	if (status != GM_SUCCESS) {
		gm_perror("gm_debug: _gm_open_common failed", status);
		gm_exit(status);
	}

	length = sizeof(struct gm_lanai_globals) +
	    (MY_MAX_NODE * sizeof(struct gm_connection));

	status = _gm_get_globals(port, (gm_u8_t *) globals, length);
	if (status != GM_SUCCESS) {
		printf("gm_debug: _gm_get_globals failed\n");
		gm_exit(status);
	}

	/* now we have a copy of the lanai_globals */

	if (GM_ENABLE_PACKET_COUNTERS) {
	    printf("netsend_cnt      %d\n", gm_ntoh_u32 (globals->netsend_cnt));
	    printf("netrecv_cnt      %d\n", gm_ntoh_u32 (globals->netrecv_cnt));
	}
	if (GM_ENABLE_ERROR_COUNTERS) {
#define GM_ERROR_CNT(name,desc)										\
		printf ("%-40s %d\n", #name, gm_ntoh_u32 (globals->name ## _error_cnt));
		GM_ERROR_COUNTERS
#include "gm_error_counters.h"
	}

	gm_close(port);

	return (0);
}

#define GM_MAIN gm_counters
#include "gm_main.h"


/*
  This comment holds special emacs settings for this file.

  Local Variables:
  tab-width:4
  c-file-style:"bsd"
  End:
*/
