/*
  BigString.java
  finucane@myri.com
  May, 1998

  Get the latest scoop package from
  http://www.myri.com/staff/finucane

*/

import java.io.*;
import java.util.*;
import java.awt.*;


public class BigString
{
  private StringBuffer buffer;
  private Vector lines;
  private Vector pages;
  private int width;
  private FontMetrics fm;
  
  private String undoString = null;
  private int undoStart;
  private int undoEnd;
  
  public BigString (int capacity, int width, Font font)
  {
    lines = new Vector ();
    pages = new Vector ();
    buffer = new StringBuffer (capacity);
    this.width = width;
    fm  = Toolkit.getDefaultToolkit().getFontMetrics(font);
  }

  public synchronized void empty ()
  {
    lines.removeAllElements ();
    pages.removeAllElements ();
    buffer.setLength (0);
    undoString = null;
  }
  public int getNumLines ()
  {
    return lines.size();
  }
  public int getNumPages ()
  {
    return pages.size ();
  }
  public synchronized void setWidth (int width)
  {
    this.width = width;
    lines.removeAllElements ();
    fill (0);
  }
  public synchronized void setFont (Font font)
  {
    fm  = Toolkit.getDefaultToolkit().getFontMetrics (font);
    lines.removeAllElements ();
    fill (0);
  }
  public int getUndoStart ()
  {
    return undoStart;
  }
  public int getUndoLength ()
  {
    return undoString != null ? undoString.length () : 0;
  }
  public synchronized void undo ()
  {
    if (undoString == null)
      return;

    insert (undoStart, undoEnd, undoString);
  }
  
  public synchronized void insert (int a, int b, String s)
  {
    //System.out.println (s);
    
    int length = buffer.length ();
    if (a < 0 || b < 0 || a >= b || b > length)
    {
      System.out.println ("BigString.insert: bad range ("+ a + "," + b + ") " + length);
      return;
    }

    int middleLength = b - a;
    int tailLength = length - b;
    int headLength = length - tailLength - middleLength;
    int expansion = s.length () - middleLength;
    
    int page = getPageAt (a + 1);
    
    char tailChars [] = new char [tailLength];
    buffer.getChars (length - tailLength, length, tailChars, 0);

    char middleChars [] = new char [middleLength];
    buffer.getChars (headLength, headLength + middleLength, middleChars, 0);
    undoString = new String (middleChars);
    undoStart = a;
    undoEnd = a + s.length ();
    
    buffer.setLength (headLength);
    buffer.append (s);
    buffer.append (tailChars);

    Vector nv = new Vector ();
    for (int i = 0; i < page; i++)
      nv.addElement (pages.elementAt (i));
    
    for (int i = page; i < pages.size (); i++)
      nv.addElement
	(new Integer (((Integer) pages.elementAt (i)).intValue () + expansion));

    pages = nv;
    
    lines.removeAllElements ();
    
    fill (0);
  }
  public synchronized void append (String s)
  {
    int start = buffer.length ();
    buffer.append (s);
    
    pages.addElement (new Integer (start));
    fill (start);
  }
  public synchronized int getPositionOfLine (int n)
  {
    if (lines.size () == 0) return 0;
    
    return ((Integer)lines.elementAt (n)).intValue ();
  }
  public synchronized int getPositionOfPage (int n)
  {
    return  ((Integer)pages.elementAt (n)).intValue ();
  }
  private int find (Vector v, int position)
  {
    int a = 0;
    int b = v.size() - 1;

    int c = 0;
    
    while (a < b - 1)
    {
      c = (a + b) / 2;
      
      int p =  ((Integer)v.elementAt (c)).intValue ();
      if (position < p)
	b = c;
      else if (position > p)
	a = c;
      else return c;
    }
    return (a + b) / 2;  
  }
  public int getPositionInLine (int line, int x)
  {
    if (x <= 0) return 0;
    
    String s = getLine (line);
    String t = "";

    int i;
    for (i = 0; i < s.length (); i++)
    {
      t += s.charAt (i);
      if (stringWidth (t) >= x)
	break;
    }
    if (i > 0 && i < s.length()) i--;
    return i;
  }
  public int stringWidth (String s)
  {
    return fm.stringWidth (s);
  }
  public synchronized int getLineAt (int n)
  {
    return find (lines, n);
  }
  public synchronized int getPageAt (int pos)
  {
    return find (pages, pos);
  }
  public synchronized int getLineOfPage (int n)
  {
    return getLineAt (getPositionOfPage (n));
  }
  public synchronized String getLine (int n)
  {
    if (n > lines.size() - 1)
      return "";
    
    int a = ((Integer)lines.elementAt (n)).intValue ();
    int b = n >= lines.size() - 1 ?
    b = buffer.length() :
    ((Integer)lines.elementAt (n + 1)).intValue ();

    return substring (a, b).trim ();
  }
  public synchronized void toFile (String filename)
  {
    try
    {
      BufferedWriter w = new BufferedWriter (new FileWriter (filename));
      w.write (buffer.toString());
      w.close ();
    }
    catch (Exception e)
    {
      System.out.println (e);
    }
  }
  public synchronized String substring (int a, int b)
  {
    char n [] = new char [b - a];
    buffer.getChars (a, b, n, 0);
    return new String (n);
  }
  public synchronized String getFilledString (int a, int b)
  {
    char n [] = new char [b - a];
    buffer.getChars (a, b, n, 0);

    int first = getLineAt (a);
    int last = getLineAt (b);

    for (int i = first + 1; i < last; i++)
      n[getPositionOfLine (i) - 1 - a] = '\n';
    
    return new String (n);
  }
  private void fill (int start)
  {
    int lastBreak = start;
    int lastSpace = start;
    boolean justBroke = true;
    int length = buffer.length ();
    String m = "This is meant to be a typical sentence, with Lots of Ms to MMM. a.  .a .aMM lllMMM";
    
    int charsPerLine = width *  m.length() / stringWidth (m);
    
    for (int i = start; i < length; i++)
    {
      if (justBroke && lastSpace != -1)
      {
	lastBreak = lastSpace;
	lines.addElement (new Integer (lastSpace != start ? lastSpace + 1 : lastSpace));
	
	justBroke = false;
	lastSpace = -1;
      }
      
      if (buffer.charAt (i) == '\n' || i - lastBreak >= charsPerLine)
	justBroke = true;

      if (Character.isWhitespace (buffer.charAt(i)))
	lastSpace = i;
    }
  } 
}
