/*
  routes_diff.c
  to compare two sets of routes
  finucane@myri.com
*/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include "mt_Component.h"
#include "mt_MapFile.h"
#include "mt_Graph.h"
#include "mt_Calculator.h"
#include "mt_Args.h"
#include "mt_RouteTable.h"
#include "mt_Follower.h"

#define die(s){mt_Component::printFormat s; exit (1);}
#define insist(e) do { if (!(e)) {mt_Component::printFormat ("Assertion failed in file %s, line %d",__FILE__,__LINE__); goto exception;}} while (0)
#define insistp(e, s) do { if (!(e)) {mt_Component::printFormat s; goto exception;}} while (0)


static void printLine (char*s)
{
  printf ("%s\n", s);
}

class Follower : public mt_Follower
{
  public:
  virtual int step (mt_Node*n, int p);
};

int Follower::step (mt_Node*node, int port)
{
  insist (node);
  
  printf ("%s:%d ", node->getName (), port);
  return 1;
  exception: return 0;
}

int main (int argc, char*argv [])
{
  mt_Component::initialize (printLine);
  mt_Route route1, route2;
  Follower follower;
  
  if (argc != 5)
    die (("usage: %s <mapfile> <routes file> <routes file> <longest distance>", argv [0]));
  
  char*mapFile = argv [1];
  char*routesFile1 = argv [2];
  char*routesFile2 = argv [3];
  int distance = atoi (argv [4]);

  if (distance < 0)
    die (("main: %s is a bad longest distance", argv [4]));

  mt_MapFile mf (mapFile, mt_File::_READ);
  mt_Graph g;

  if (!mf.read (&g))
    die (("main: couldn't parse map file %s", mapFile));

  mt_RouteTable rt1;
  mt_RouteTable rt2;
  
  if (!rt1.fromFile (routesFile1, &g))
    die (("main: couldn't parse routes file %s", routesFile1));

  if (!rt2.fromFile (routesFile2, &g))
    die (("main: couldn't parse routes file %s", routesFile2));

  int numHosts = g.getNumHosts ();
  insist (numHosts > 0);
  
  for (int i = 0; i < numHosts; i++)
  {
    mt_Node*h1 = g.getHost (i);
    insist (h1);
    
    for (int j = 0; j < numHosts; j++)
    {
      mt_Node*h2 = g.getHost (j);
      insist (h2);
      
      if (h1->getDistance (h2) > distance)
	continue;
 
      int r1 = rt1.getRoute (i, j, 0, &route1);
      int r2 = rt2.getRoute (i, j, 0, &route2);
      insist (r1 && r2);
      
      if (route1.equals (&route2))
	continue;
 
      mt_Node*node;
      int in;

      printf ("route difference from: %s to %s\n", h1->getName (), h2->getName ());
      printf ("route from file %s:\n", routesFile1);
      printf ("length: %d\n", route1.getLength ());
      printf ("route: %s\n", route1.toString ());
      printf ("path: ");
      h1->follow (&route1, &node, &in, &follower);
      printf ("\n\n");
      printf ("route from file %s:\n", routesFile2);
      printf ("length: %d\n", route2.getLength ());
      printf ("route: %s\n", route2.toString ());
      printf ("path: ");
      h1->follow (&route2, &node, &in, &follower);
      printf ("\n\n\n");
      
    }
  }  
  return 0;
  exception: return 1;
}




