/*
  routes4danny.c
  to convert a routes file to form usable by danny
  finucane@myri.com
*/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include "mt_Component.h"
#include "mt_MapFile.h"
#include "mt_Graph.h"
#include "mt_Calculator.h"
#include "mt_Args.h"
#include "mt_RouteTable.h"
#include "mt_Follower.h"

#define die(s){mt_Component::printFormat s; exit (1);}
#define insist(e) do { if (!(e)) {mt_Component::printFormat ("Assertion failed in file %s, line %d",__FILE__,__LINE__); goto exception;}} while (0)
#define insistp(e, s) do { if (!(e)) {mt_Component::printFormat s; goto exception;}} while (0)


static int shortOutput = 0;

static void printLine (char*s)
{
  printf ("%s\n", s);
}

class Follower : public mt_Follower
{
  public:
  mt_Route*route;
  int hop;
  virtual int step (mt_Node*n, int p);
};

int Follower::step (mt_Node*node, int port)
{
  insist (node && route);
  
  if (shortOutput)
    printf ("%s ", node->getName ());
  else
  { 
    if (hop == -1 || hop >= route->getLength ())
      printf ("%s:%d ", node->getName (), port);
    else
      printf ("%s:%d:%d ", node->getName (), port, port + *(route->getHops() + hop));
  }
  
  hop++;

  return 1;  
  exception: return 0;
}

int main (int argc, char*argv [])
{
  mt_Component::initialize (printLine);
  mt_Route route;
  Follower follower;
  
  if (argc != 3 && argc != 4)
    die (("usage: %s <mapfile> <routefile> [short-output]", argv [0]));
  
  char*mapFile = argv[1];
  char*routesFile = argv[2];
  
  shortOutput = argc == 4;
  
  mt_MapFile mf (mapFile, mt_File::_READ);
  mt_Graph g;

  if (!mf.read (&g))
    die (("main: couldn't parse map file %s", mapFile));

  mt_RouteTable rt;

  if (!rt.fromFile (routesFile, &g))
    die (("main: couldn't parse routes file %s", routesFile));

  int numHosts = g.getNumHosts ();
  insist (numHosts > 0);
  
  for (int i = 0; i < numHosts; i++)
  {
    mt_Node*h = g.getHost (i);
    insist (h);
    
    for (int j = 0; j < numHosts; j++)
    {
      for (int k = 0; k < rt.getNumRoutes (h->getRouteIndex (), g.getHost (j)->getRouteIndex ()); k++)
      {
	
	int r = rt.getRoute (h->getRouteIndex (), g.getHost (j)->getRouteIndex (), k, &route);
	insist (r);

	mt_Node*fn;
	int fin;
      
	insist (h->follow (&route, &fn, &fin));
	if (fn != g.getHost (j))
	{
	  die (("probably host order mismatch between route and map file"));
	}

	mt_Node*node;
	int in;

	follower.route = &route;
	follower.hop = -1;

	if (shortOutput)
	  printf ("from %s to %s // ", h->getName (), g.getHost (j)->getName ());
	else
	{
	  printf ("from: %s to %s\n", h->getName (), g.getHost (j)->getName ());
	  printf ("length: %d\n", route.getLength ());
	  printf ("route: %s\n", route.toString ());
	  printf ("path: ");
	}
	
	h->follow (&route, &node, &in,  &follower);
	printf ("\n");
      }
    }
  }  
  return 0;
  exception: return 1;
}




