/*
  reduce.c
  remove nodes from a map file
  finucane@myri.com
*/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include "mt_Component.h"
#include "mt_MapFile.h"
#include "mt_Graph.h"
#include "mt_Args.h"
#include "mt_Host.h"
#include "mt_FileWriter.h"

#define die(s){mt_Component::printFormat s; exit (1);}
#define insist(e) do { if (!(e)) {mt_Component::printFormat ("Assertion failed in file %s, line %d",__FILE__,__LINE__); goto exception;}} while (0)
#define insistp(e, s) do { if (!(e)) {mt_Component::printFormat s; goto exception;}} while (0)

#define FIRST_NODE 3

static void printLine (char*s)
{
  printf ("%s\n", s);
}

static int isMarked (mt_Node*n1, mt_Node*n2, int)
{
  insist (n1 && n2);
  return n1->isMarked () || n2->isMarked ();
  exception: return 0;
}

int main (int argc, char*argv [])
{
  mt_Component::initialize (printLine);
  mt_Route route;
  
  if (argc < FIRST_NODE)
    die (("usage: %s <sourcefile> <destfile> [<node> <node> ...]", argv [0]));
  
  char*mapFile = argv [1];
  char*destFile = argv [2];
  
  mt_MapFile mf (mapFile, mt_File::_READ);
  mt_Graph g;

  if (!mf.read (&g))
    die (("main: couldn't parse map file %s", mapFile));

  g.clearMarks ();
  
  for (int i = FIRST_NODE; i < argc; i++)
  {
    mt_Node*n;
    if (!(n = g.getNode (argv [i])))
      die (("%s is not in map file %s", argv [i], mapFile));
    n->setMark (mt_Node::UP);
  }
  
  if (!g.removeLinks (mt_fp (isMarked)) || !g.removeSteppenwoelfe ())
    die (("etwas schlimmes hat passiert"));
  
  mt_FileWriter w (destFile);
  if (!w.fp)
    die (("couldn't create %s", destFile));
 
   mt_MapFile m (w.fp);
   m.write (&g);
   return 0;
}


