/*
  ping.c
  myrinet ping
  finucane@myri.com (David Finucane)
*/


#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <signal.h>

#include "mt_Calculator.h"
#include "mt_Simulation.h"
#include "sm_Simulator.h"
#include "mt_Network.h"
#include "mt_Args.h"
#include "mt_Host.h"
#include "pi_Ping.h"

#define die(s){mt_Component::printFormat s; exit (1);}
#define insist(e) do { if (!(e)) {mt_Component::printFormat ("Assertion failed in file %s, line %d",__FILE__,__LINE__); goto exception;}} while (0)
#define insistp(e, s) do { if (!(e)) {mt_Component::printFormat s; goto exception;}} while (0)

static pi_Ping*ping = 0;

static void handleSignal (int)
{
  if (ping)
    ping->print (1);
  
  exit (0);
}

static void printLine (char*s)
{
  printf ("%s\n", s);
  fflush (stdout);
}

static mt_Network*network = 0;

int main (int argc, char *argv[]) 
{
  mt_Component::initialize (printLine);
  mt_Calculator*calculator;
  
  if (!(calculator = mt_getCalculator ()))
    die (("mt_getCalculator failed"));

#ifdef TEST
  mt_Simulation*simulation;
  simulation = mt_getSimulation ();
  if (!simulation)
    die (("mt_getSimulation failed"));
#endif
  
  network =  mt_getNetwork ();
  if (!network)
    die (("couldn't create network"));
  
#ifndef TEST
  mt_Host n ("-", "-");
  pi_Options options;
#endif

  mt_Args*args = new mt_Args (argc, argv);
  if (argc == 1 || !args)
  {
    printf("usage: %s ",argv[0]);
    mt_Args::usage ();
    printf("\n");

    calculator->usage();
    printf("\n");

    network->usage();
    printf ("\n");
    
#ifdef TEST
    simulation->usage ();
    printf ("\n");
#else
    options.usage();
    printf("\n");
#endif
    return 0;
  }

  if (!(calculator->parseArgs (args)))
  {
    mt_Args::usage ();
    calculator->usage ();
    return 1;
  }
#ifdef TEST
  if (!(simulation->parseArgs (args)))
  {
    mt_Args::usage ();
    simulation->usage ();
    return 1;
  }
#else
  if (!(options.parseArgs (args)))
  {
    mt_Args::usage ();
    options.usage ();
    return 1;
  }  
#endif
  if (!(network->parseArgs (args)))
  {
    mt_Args::usage ();
    network->usage ();
    return 1;
  }
  
  signal (SIGINT, handleSignal);
  signal (SIGTERM, handleSignal);

#ifdef TEST
  sm_Simulator*simulator = (sm_Simulator*) network;
  
  if (!simulator->initialize (calculator, simulation))
    die (("couldn't initialize network"));
  
  simulator->run ();
  simulator->simpleDump (stdout);
  simulator->cleanup ();

  delete simulation;
  
#else

  ping = new pi_Ping (&n, network, calculator, &options);
  if (!ping)
    die (("couldn't alloc ping")); 

  if (!ping->start ())
    die (("couldn't start ping"));

  ping->print ();
  
  delete ping;
  ping = 0;
#endif
  
  delete calculator;
  delete network;
  
  return 0;
}
