/*
  mapper.c
  mapper program
  finucane@myri.com (David Finucane)
*/


#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <signal.h>

#include "mt_Calculator.h"
#include "mt_MapperModule.h"
#include "mt_Network.h"
#include "mt_Args.h"

#define die(s){mt_Component::printFormat s; exit (1);}
#define insist(e) do { if (!(e)) {mt_Component::printFormat ("Assertion failed in file %s, line %d",__FILE__,__LINE__); goto exception;}} while (0)
#define insistp(e, s) do { if (!(e)) {mt_Component::printFormat s; goto exception;}} while (0)

static void printLine (char*s)
{
  printf ("%s\n", s);
  fflush (stdout);
}

static mt_Network*network = 0;

static void handleSignal (int)
{
  if (network)
    network->abort ();
}

int main (int argc, char *argv[]) 
{
  mt_Calculator*calculator;
  mt_MapperModule*mapper;
  
  mt_Component::initialize (printLine);
  
  signal (SIGINT, handleSignal);
  signal (SIGTERM, handleSignal);  

  if (!(calculator = mt_getCalculator ()))
    die (("couldn't create calculator"));
  
  network = (mt_Network*) mt_getNetwork ();
  if (!network)
    die (("couldn't create network"));

  mapper = (mt_MapperModule*) mt_getMapperModule ();
  if (!mapper)
    die (("couldn't create mapper"));
  
  mt_Args*args = new mt_Args (argc, argv);
  if (argc == 1 || !args)
  {
    printf("usage: %s ",argv[0]);
    mt_Args::usage ();
    printf("\n");

    calculator->usage();
    printf("\n");

    network->usage();
    printf ("\n");
    return 0;
  }
  if (!(calculator->parseArgs (args)))
  {
    mt_Args::usage ();
    calculator->usage ();
    return 1;
  }

  if (!(network->parseArgs (args)))
  {
    mt_Args::usage ();
    network->usage ();
    return 1;
  }
  
  if (!(mapper->parseArgs (args)))
  {
    mt_Args::usage ();
    mapper->usage ();
    return 1;
  }

  if (!mapper->initialize (network, calculator))
    die (("couldn't initialize mapper"));

  if (!mapper->start ())
    die (("couldn't start mapper"));
  
  mapper->cleanup ();
   
  delete calculator;
  delete network;
  delete mapper;
  
  return 0;
}
