/*
  map2wiring.c
  map file to wiring diagram
  finucane@myri.com (David Finucane)
*/


#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include "mt_Component.h"
#include "mt_MapFile.h"
#include "mt_Graph.h"
#include "mt_Args.h"

#define die(s){mt_Component::printFormat s; exit (1);}
#define insist(e) do { if (!(e)) {mt_Component::printFormat ("Assertion failed in file %s, line %d",__FILE__,__LINE__); goto exception;}} while (0)
#define insistp(e, s) do { if (!(e)) {mt_Component::printFormat s; goto exception;}} while (0)


static void printLine (char*s)
{
  printf ("%s\n", s);
}

static void printWire (mt_Node*n)
{
  insist (n);
  
  for (int i = 0; i < n->getMaxNodes (); i++)
  {
    mt_Node*o = n->getNode (i);
    
    if (o)
    {
      mt_Component::printFormat ("%s:%d %s:%d", n->getName (), i, o->getName (), n->getOpposite (i));
      o->disconnect (n->getOpposite (i));
      n->disconnect (i);
    }
  }
  
  exception: return;
}

int main (int argc, char*argv[])
{  
  mt_Component::initialize (printLine);
  
  if (argc != 2)
    die (("usage: %s <mapfile>", argv[0]));
 
  char*mapFile = argv [1];

  mt_MapFile mf (mapFile, mt_File::_READ);

  mt_Graph g;
  
  if (!mf.read (&g))
    die (("main: couldn't parse map file %s", mapFile));

  for (int i = 0; i < g.getNumHosts (); i++)
    printWire (g.getHost (i));
  
  for (int i = 0; i < g.getNumSwitches (); i++)
    printWire (g.getSwitch (i));
  return 0;
}
