/*
  map2routes.c
  map file to route file program
  finucane@myri.com (David Finucane)
  dmazzoni@myri.com (Dominic Mazzoni)
*/


#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include "mt_Component.h"
#include "mt_MapFile.h"
#include "mt_Graph.h"
#include "mt_Calculator.h"
#include "mt_Args.h"
#include "mt_RouteTable.h"

#define die(s){mt_Component::printFormat s; exit (1);}
#define insist(e) do { if (!(e)) {mt_Component::printFormat ("Assertion failed in file %s, line %d",__FILE__,__LINE__); goto exception;}} while (0)
#define insistp(e, s) do { if (!(e)) {mt_Component::printFormat s; goto exception;}} while (0)


static void printLine (char*s)
{
  printf ("%s\n", s);
}

int main (int argc, char *argv[]) 
{
  mt_Component::initialize (printLine);

  mt_Args*args = new mt_Args (argc, argv);
  if (!args || argc < 3)
    die (("usage: %s <mapfile> <routefile || stdout> -route-args ...", argv[0]));
  
  char*filename = argv[1];
  char*outfile = argv[2];

  mt_MapFile mf (filename, mt_File::_READ);
  mt_Graph g;
    
  if (!mf.read (&g))
    die (("main: couldn't parse map file"));

  mt_Calculator*cg = mt_getCalculator ();
    
  if (!cg)
    die (("main: couldn't get calculator"));

  if (!cg->parseArgs (args))
  {
    cg->usage ();
    delete cg;
    return 1;
  }

  if (!cg->initialize (filename))
    die (("main: couldn't initialize calculator"));

  if (!strcmp(outfile,"stdout"))
    cg->writeRoutes (stdout);
  else
    cg->writeRoutes (outfile);

  cg->cleanup ();
  delete cg;

  return 0;
}

