/*
  nt_mapper_service.c
  gm mapper
  finucane@myri.com (David Finucane)
*/

#include <windows.h>
#include <winsvc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mt_Calculator.h"
#include "mt_MapperModule.h"
#include "mt_Network.h"
#include "mt_Args.h"
#include "mt_File.h"

#define FILENAME_LENGTH 255
#define LOG_FILENAME "mapper.log"
#define ARGS_FILENAME "mapper.args"
#define MAX_LOG 20000


#define die(s){mt_Component::printFormat s; exit (1);}
#define insist(e) do { if (!(e)) {mt_Component::printFormat ("Assertion failed in file %s, line %d",__FILE__,__LINE__); goto exception;}} while (0)
#define insistp(e, s) do { if (!(e)) {mt_Component::printFormat s; goto exception;}} while (0)


static char errorFilename [FILENAME_LENGTH];
static char baseName [FILENAME_LENGTH];
static char argsFilename [FILENAME_LENGTH];
static char*serviceName = "GM Mapper";
static SERVICE_STATUS_HANDLE statusHandle;
static SERVICE_STATUS  statusThing;
static mt_Network*network = 0;
static int printToScreen = 1;
static char*args [2];

static void printLine (char*s)
{
  FILE*fp = 0;
  static int mc = 0;

  if (printToScreen)
  {
    printf ("%s\n", s);
    return;
  }
  if (!(fp = fopen (errorFilename, ++mc % MAX_LOG ? "a+" : "w+")))
    return;
  
  fprintf (fp,"%s\n", s);
  fclose (fp);
}

static void startMapper (int argc, char*argv[])
{
  mt_Calculator*calculator;
  mt_MapperModule*mapper;
  
  mt_Args*args = new mt_Args (argc, argv);
  if (!args)
    die (("arg"));
  
  if (!(calculator = mt_getCalculator ()))
    die (("mt_getCalculator failed"));
  
  if (!(calculator->parseArgs (args)))
  {
    mt_Args::usage ();
    calculator->usage ();
    return;
  }
  

  network = (mt_Network*) mt_getNetwork ();
  if (!network)
    die (("couldn't create network"));
  
  if (!(network->parseArgs (args)))
  {
    mt_Args::usage ();
    network->usage ();
    return;
  }
  
  mapper = (mt_MapperModule*) mt_getMapperModule ();
  if (!mapper)
    die (("couldn't create mapper"));
  
  if (!(mapper->parseArgs (args)))
  {
    mt_Args::usage ();
    mapper->usage ();
    return;
  }

  if (!mapper->initialize (network, calculator))
    die (("couldn't initialize mapper"));

  if (!mapper->start ())
    die (("couldn't start mapper"));
  
  mapper->cleanup ();
  delete calculator;
  delete network;
  delete mapper;
}

void __stdcall serviceHandler (DWORD code)
{
  switch (code)
  {
    case SERVICE_CONTROL_STOP:
      if (network)
	network->abort ();
      statusThing.dwWin32ExitCode = 0;
      statusThing.dwCurrentState = SERVICE_STOP_PENDING;
      statusThing.dwCheckPoint = 0;
      statusThing.dwWaitHint = 0;
      break;
    case SERVICE_CONTROL_INTERROGATE:
    case SERVICE_CONTROL_PAUSE:
    case SERVICE_CONTROL_CONTINUE:
    default:
      break;
  }
  if (!SetServiceStatus (statusHandle, &statusThing))
    mt_Component::printFormat ("SetServiceStatus error %ld.", GetLastError);
}


void __stdcall serviceStart (DWORD argc, LPTSTR*argv)
{
  statusThing.dwServiceType = SERVICE_WIN32_OWN_PROCESS;
  statusThing.dwCurrentState = SERVICE_RUNNING;
  statusThing.dwControlsAccepted = SERVICE_ACCEPT_STOP;
  statusThing.dwWin32ExitCode = 0;
  statusThing.dwServiceSpecificExitCode = 0;
  statusThing.dwCheckPoint = 0;
  statusThing.dwWaitHint = 0;

  if (!(statusHandle = RegisterServiceCtrlHandler (serviceName, serviceHandler)))
  {
    printLine ("RegisterServiceCtrlHandler failed.");
    return;
  }

  if (!SetServiceStatus (statusHandle, &statusThing))
    mt_Component::printFormat ("SetServiceStatus error %ld.", GetLastError());
  
  startMapper (2, args);
  
  statusThing.dwCurrentState = SERVICE_STOPPED;
  statusThing.dwWin32ExitCode = 0;
  statusThing.dwServiceSpecificExitCode = 0;
  statusThing.dwCheckPoint = 0;
  statusThing.dwWaitHint = 0;

  if (!SetServiceStatus (statusHandle, &statusThing))
    mt_Component::printFormat ("SetServiceStatus error %ld.", GetLastError());
 
}

int main (int argc, char *argv[])
{
  SERVICE_TABLE_ENTRY st[] =
  {
    {serviceName, serviceStart},
    {NULL, NULL}
  };
  
  mt_Component::initialize (printLine);

  mt_File::getFullPath (errorFilename, LOG_FILENAME);
  mt_File::getFullPath (argsFilename, ARGS_FILENAME);

#if 0
  makeFilenames ();
#endif

  args [0] = argv [0];
  args [1] = argsFilename;
  
  if (argc > 1)
  {
    /* Act as a normal app */
    startMapper (argc, argv);
    return 0;
  }
  printToScreen = 0;
  
  /* Act as a service. */
  if (!StartServiceCtrlDispatcher (st))
  {
    mt_Component::printFormat ("StartServiceCtrlDispatcher error %ld", GetLastError ());
    return 1;
  }
  return 0;
}

