/*
  best.c
  map tools
  finucane@myri.com (David Finucane)
*/


#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <signal.h>

#include "mt_Args.h"
#include "mt_Simulation.h"
#include "mt_MapFile.h"
#include "sm_Simulator.h"

#define die(s){mt_Component::printFormat s; exit (1);}
#define insist(e) do { if (!(e)) {mt_Component::printFormat ("Assertion failed in file %s, line %d",__FILE__,__LINE__); goto exception;}} while (0)
#define insistp(e, s) do { if (!(e)) {mt_Component::printFormat s; goto exception;}} while (0)

static void printLine (char*s)
{
  printf ("%s\n", s);
}

static void handleSignal (int)
{
  exit (1);
}

int main (int argc, char *argv[]) 
{
  int r;
  char*numPackets;
  
  sm_Simulator* simulator = 0;
  
  mt_Component::initialize (printLine);

  if (argc != 3)
    die (("usage: %s <mapfile> <num-messages>\n", argv[0]));

  char*mapFile = argv [1];
  mt_MapFile mf (mapFile, mt_File::_READ);

  numPackets = argv [2];
  
  mt_Graph graph;
  
  if (!mf.read (&graph))
    die (("main: couldn't parse map file %s", mapFile));
  
  mt_Simulation*simulation = 0;
  mt_Calculator*calculator = 0;

  for (int i = 0; i < graph.getNumSwitches (); i++)
  {
    simulator = (sm_Simulator*) mt_getNetwork ();
    if (!simulator)
      die (("couldn't create simulator"));

    simulation = mt_getSimulation ();
    if (!simulation)
      die (("mt_getSimulation failed"));

    calculator = mt_getCalculator ();
    if (!calculator)
      die (("mt_getCalculator failed"));

    mt_Args*simulationArgs = new mt_Args (mt_Args::SIMULATION, 2);
    insistp (simulationArgs, ("couldn't alloc simulationArgs"));
  
    simulationArgs->addArg ("-packet-length");
    simulationArgs->addArg ("100");

    mt_Args*simulatorArgs;
    simulatorArgs = new mt_Args (mt_Args::SIMULATOR, 4);
    insistp (simulationArgs, ("couldn't alloc simulatorArgs"));

    simulatorArgs->addArg ("-map-file");
    simulatorArgs->addArg (mapFile);
    simulatorArgs->addArg ("-num-packets");
    simulatorArgs->addArg (numPackets);
  
    signal (SIGINT, handleSignal);
    signal (SIGTERM, handleSignal);

    r = simulator->parseArgs (simulatorArgs);
    insist (r);
    r = simulation->parseArgs (simulationArgs);
    insist (r);
  
    mt_Node*s = graph.getSwitch (i);
    insist (s);
    
    mt_Node*n;
    n = s->getAnyHost ();
    if (!n) continue;
    
    mt_Args*calculatorArgs = new mt_Args (mt_Args::CALCULATOR, 3);
    insistp (calculatorArgs, ("couldn't alloc args"));
    
    calculatorArgs->addArg ("-roots");
    calculatorArgs->addArg ("1");
    calculatorArgs->addArg (graph.getSwitch (i)->getName ());
    
    r = calculator->parseArgs (calculatorArgs);
    insist (r);

    r = simulator->initialize (calculator, simulation);
    insist (r);
    
    while (simulator->step (1));

    for (int j = 0; j < s->getMaxNodes (); j++)
    {
      mt_Node*h = s->getNode (j);
      if (h && h->isHost ())
	mt_Component::printFormat ("%5.4f %s", simulator->getUtilization (), h->getName ());
    }

    delete simulator;
    delete simulatorArgs;
    delete simulationArgs;
    delete calculatorArgs;
    delete calculator;
  }
  exception:;
  return 0;
}
