#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mt_MapFile.h"
#include "sw_Test16.h"
#include "sw_Sender.h"

#define die(s){mt_Component::printFormat s; exit (1);}
#define call(e)   t++; r += e; if (lazy && t != r) goto the_end

static void printLine (char*s)
{
  printf ("%s\n", s);
}

int main (int argc, char*argv [])
{
  mt_Component::initialize (printLine);
  char*mapFile = argv [2];
  char*hostname = argv [3];
  char*switchname = argv [4];
  char*switchmapname = argv [5];
  char*lazyname = argv [6];
  char*lanainame = argv [7];
  mt_Node*h;
  mt_Node*s;
  int unit;
  int lazy;
  int lanai;
  
  if (argc != 8) die (("usage: %s <unit> <map file> <host> <switchname> <switch-map-name> <lazy | eager> <lanai-version>", argv [0]));

  mt_MapFile mf (mapFile, mt_File::_READ);
  mt_Graph graph;
  
  unit = atoi (argv [1]);
  
  if (!mf.read (&graph))
    die (("couldn't parse map file %s", mapFile));

  if (!(h = graph.getNode (hostname)) || !h->isHost ())
    die (("%s is not a host in map file %s", hostname, mapFile));
  
  if (!(s = graph.getNode (switchmapname)) || !s->isSwitch ())
    die (("%s is not a switch in map file %s", switchmapname, mapFile));
  
  if (strcmp (lazyname, "lazy") && strcmp (lazyname, "eager"))
    die (("%s is neither lazy nor eager", lazyname));
  
  lazy = !strcmp (lazyname, "lazy");
  lanai = atoi (lanainame);
  
  sw_TestPort port (switchname);
  sw_Test16 test (unit, &graph, mt_getNetwork (), h, &port, 1, &s, 1, lazy, lanai);
  int xbar = 0;

  int r,t;
  r = t = 0;

  test.initialize (xbar);  

  test.testBandwidth (xbar);

  port.disableUpdate (xbar);
  port.disableImpedence (xbar);
  port.setRelays (xbar, 0xffff);
  port.resetXbar (xbar);

  call (test.testId (xbar));
  call (test.testGlobalControl (xbar));
  call (test.testImpedence (xbar));

  port.enableImpedence (xbar);
  port.enableUpdate (xbar);
  port.usleep (1000 * 1000 * 2);

  call (test.testPorts (xbar));
  call (test.testMessage (xbar));
  call (test.testCrosspoints (xbar));
  call (test.testCounters ());

  test.enableCrc ();
  port.disableUpdate (xbar);

  call (test.testInvalidHeads (xbar));
  call (test.testTimeouts (xbar));
  call (test.testPortOnOff (xbar));

  call (test.testIllegal (xbar));


  port.enableUpdate (xbar);
  
  the_end:

  mt_Component::printFormat ("%d / %d received in all", sw_Sender::getTotalReceived (), sw_Sender::getTotalSent ());  

  test.printResult (t == r);
  
  return 0;
}
