/*
  sw_TestPort.h
  class to access switch test port
  finucane@myri.com (David Finucane)
*/

#ifndef sw_TestPort_h
#define sw_TestPort_h

#include <stdarg.h>
#include "mt_Component.h"


typedef struct sw_TestPortState
{
  int xbar;
  int port;
  int uptime;
  int good_low;
  int good_high;
  int bad_low;
  int bad_high;
  int timeouts;
  int illegal_symbols;
  int missed_beats;
  int bad_routes;
  int dead_routes;
  int port_state;
  int control;
} sw_TestPortState;

class sw_TestPort : public mt_Component
{
  public:
  enum
  {
    NUM_PORTS = 16,
    SWITCHNAME_LENGTH = 256,
    BIAS_CHANNEL = 1,
    VTH_CHANNEL = 2,
    OAL_CHANNEL = 3,
    OAH_CHANNEL = 4,
    LVDD_CHANNEL = 5,
  };
  static const double VSCALE10 = 0.00244379276637341153;
  
  private:
  int fd;
  
  char addressBuffer [64];
  int addressLength;
  
  protected:
  char switchname [SWITCHNAME_LENGTH];
  
  int open (int port);
  int close ();
  int send (char*m, int size);
  int receive (char*m, int size);
  int read (int fd, char*buffer, int length);
  int send (char*request, int requestLength, char*response, int responseLength);
  int simpleCommand (int xbar, int type);
  
  public:  
  sw_TestPort (char*switchname);
  int getChipId (int xbar, char*low, char*high);
  int getGlobalControl (int xbar, char*low);
  int setGlobalControl (int xbar, char low);
  int getOutputImpedence (int xbar, char*low1, char*high1, char*low2, char*high2);
  int setOutputImpedence (int xbar, char low1, char high1, char low2, char high2);
  int getTestImpedence (int xbar, char*low, char*high);
  int setTestImpedence (int xbar, char low, char high);
  int enableUpdate (int xbar);
  int disableUpdate (int xbar);
  int disableImpedence (int xbar);
  int enableImpedence (int xbar);
  int setRelays (int xbar, int data);
  int resetXbar (int xbar);
  int getA2D (int xbar, int channel);
  int getVoltages (int xbar, int*low, int*high);
  int getVoltages (int xbar, int*low, int*high, int lowLimit, int highLimit);
  double getVoltage (int xbar, int channel);
  int usleep (int usecs);
  int getLinkStatus (int xbar, char receive [NUM_PORTS], char transmit [NUM_PORTS]);
  int setIcs (int value);
  int accessMicrocontroller (int port, int*receiveLength, char*buffer, int sendLength, ...);
  int setChannel160 ();
  int setChannel200 ();
  int setBClock (int xbar, int value);
  int getPacketCounters (int xbar, int good [NUM_PORTS], int bad [NUM_PORTS]);
  int setControl (int xbar, char control [NUM_PORTS]);
  int getControl (int xbar, char control [NUM_PORTS]);
  int getPortStates (int xbar, sw_TestPortState*states);
  
  
  int getOutputImpedence (int xbar, char*low, char*high);
  int setOutputImpedence (int xbar, char low, char high);
  int setHa (int on);
  int setAuto (int on);
  int setSpeed (int xbar, char c1, char c2, char c3, char c4);
  int setSpeed (int xbar, int port, int fast);
  int getSpeed (int xbar, char speed [4]);
  static int getReceiveLinkStatusField (char receive [12 * 16 / 8], int port, int field);
  static int getTransmitLinkStatusField (char transmit [4 * 16 / 8], int port, int field);
  int getLinkStatus2 (int xbar, char receive [12 * 16 / 8], char transmit [4 * 16 / 8]);
  static int extractReceive(int port, char receive[12*16/8]);
  static int extractTransmit(int port, char transmit[4*16/8]);
};


#endif /*sw_TestPort_h*/
