/*
  sw_Test16.h
  class to test a 16 port switch
  finucane@myri.com (David Finucane)
*/

#include <stdarg.h>
#include "mt_Network.h"
#include "sw_TestPort.h"
#include "sw_Sender.h"

class sw_Test16;

typedef int (sw_Test16::*sw_Test16GetCount)(int xbar, int port);
typedef int (sw_Test16::*sw_Test16GetCounts)(int xbar, int*counts);

class sw_Test16 : public mt_Job
{
  protected:
  enum
  {
    MAX_SWITCHES = 100
  };

  sw_TestPort*testPort;
  int opened;
  int routesComputed;
  int portCorrection;
  int portCorrectionXbar;
  mt_Graph*graph;
  mt_Node*host;
  int numSwitches;
  mt_Node*switches [MAX_SWITCHES];
  int xbars [MAX_SWITCHES];
  int verbose;
  int lazy;
  int lanai;
  int unit;
  int open ();
  int reopen ();
  int close ();
  int sortSwitches ();
  int testCounters (int xbar, int waitForReceive, sw_Test16GetCounts getCount);
  int testCounters (int xbar, int waitForReceive, sw_Test16GetCounts getCount, int count);
  int testSnakeyCounters (int xbar, int count);
  int testOuterCounters (int xbar, sw_Test16GetCount getCount, int count);
  int getGoodCount (int xbar, int port);
  int getBadCounts (int xbar, int*counts);
  int getGoodCounts (int xbar, int*counts);
  int getSomeGoodCounts (int xbar, int*badCount, int*badPort);
  int getBadCount (int xbar, int port);
  int computeRoutes ();
  int getPortCorrection (int xbar);
  int send (int xbar, int receiveWait, int sendWait, int size, int count, int*numReceived = 0);
  int send (int xbar, int receiveWait, int sendWait, int port, int hop, int size, int count, int*numReceived = 0);
  int snakeySend (int xbar, int receiveWait, int sendWait, int size, int count, int*numReceived);
  
  int testIllegal (int xbar, int port);
  int testInvalidHeads (int xbar, int port);
  int testTimeouts (int xbar, int port);
  int deadlock (int xbar, int port);
  int testPortOnOff (int xbar, int port);
  double getBandwidth (int xbar, int port=-1);
  virtual int getIllegalSymbols (int xbar, int port);
  virtual int getStatusUpdate (int xbar, int port);
  virtual int getPortShutdown (int xbar, int port);
  virtual int getInvalidHeads (int xbar, int port);
  virtual int getTimeout (int xbar, int port, int set);

  public:
  sw_Test16 (int unit, mt_Graph*graph, mt_Network*network, mt_Node*host, sw_TestPort*port, int numSwitches, mt_Node**switches, int verbose, int lazy, int lanai);
  ~sw_Test16 ();
  
  int testId (int xbar);
  int testGlobalControl (int xbar, char vlow);
  int testGlobalControl (int xbar);
  virtual int testOutputImpedence (int xbar, char vlow1, char vhigh1, char vlow2, char vhigh2);
  virtual int testInitialOutputImpedence (int xbar);
  
  int testTestImpedence (int xbar, char vlow, char vhigh);
  int testImpedence (int xbar);
  int testMonotonicity (int xbar);
  int testPorts (int xbar);
  int testMessage (int xbar);
  int testCrosspoints (int xbar);
  int testCounters ();
  int testIllegal (int xbar);
  int testInvalidHeads (int xbar);
  int testTimeouts (int xbar);
  int testPortOnOff (int xbar);
  int enableCrc ();
  int disableCrc ();
  int testBandwidth (int xbar);
  int initialize (int xbar);
  int printResult (int result);
  int printBadCounters (int xbar);
  
  int send (int xbar, int receiveWait, int sendWait, int port, int size, int count, int*numReceived = 0);

  virtual void dump (FILE*fp);
  virtual int willWait ();
  virtual int start ();
  virtual void receive (int event, char*p, int length);
};
