/*
  sw_SnakeySender.h
  "message test"
  finucane@myri.com (David Finucane)
*/

#include "sw_SnakeySender.h"
#include "insist.h"

sw_SnakeySender::sw_SnakeySender (mt_Job*job, mt_Network*network, mt_Graph*graph, mt_Node*_switch, int receiveWait, int sendWait, int length, int count) : sw_Sender (job, network, graph, receiveWait, sendWait)
{
  this->length = length;
  this->count = count;
  this->_switch = _switch;
}

int sw_SnakeySender::startThread ()
{
  mt_Route r (200);

  insist (this);
  insist (length > 0 && length <= mt_Network::MTU);

  if (!sw_Sender::startThread ())
    return 0;
 
  graph->computeRoutes (job->getNode ());
  
  if (!getSnakeyRoute (&r, _switch))
    return 0;
  
  //printFormat ("snakey route is %s", r.toString ());
  
  int phase;
  phase = 0;

  for (int i = 0; i < count; i++)
  {
    mt_ProbeMessage m (0, phase++);
    m.swap ();

    if (!sendProbe (&r, &m, length))
    {
      printFormat ("sendProbe failed");
      return 0;    
    }
  }
  waitForReceives ();  
  
  return !receiveWait || getNumSent () == getNumReceived ();
  exception: return 0;
}
