/*
  sw_Sender.h
  thing to send messages into a switch
  finucane@myri.com (David Finucane)
*/

#ifndef sw_Sender_h
#define sw_Sender_h

#include "mt_Component.h"
#include "mt_Network.h"
#include "mt_Message.h"
#include "sw_Threadable.h"
#include "sw_TestPort.h"

class sw_Sender;

typedef void (sw_Sender::*sw_SenderHandler)(char*p, int length);

class sw_Sender : public mt_Component, public sw_Threadable
{
  public:
  enum
  {
    TIMEOUT = 1000 * 1000 * 1000
  };
  private:
  static int totalSent;
  static int totalReceived;

  sw_SenderHandler handlers [mt_Message::NUM_TYPES];
  
  int send (mt_Route*route, char*p, int length);
  int setHandler (int type, sw_SenderHandler handler);
  int clearHandler (int type);
  void handleReply (char*p, int length);
  void handleProbe (char*p, int length);
  
  protected:
  int numSent;
  int numReceived;
  int numSendDones;
  int receiveWait;
  int sendWait;
  mt_Job*job;
  mt_Network*network;
  int counts [sw_TestPort::NUM_PORTS];

  char buffer [mt_Network::MTU + mt_Route::MAX_ROUTE];
  mt_Graph*graph;
  int sendProbe (mt_Route*route, mt_ProbeMessage*m, int length);
  int wait (int event, int type, char**p, int*length);
  int wait (int timeout, int type, int count);
  int getSwitchRoute (mt_Route*route, mt_Node*_switch, int port);
  int flushSends ();
  
  public:
  sw_Sender (mt_Job*job, mt_Network*network, mt_Graph*graph, int receiveWait, int sendWait);
  ~sw_Sender ();
  
  virtual int startThread ();

  int getNumSent ();
  int getNumReceived ();
  static int getTotalSent ();
  static int getTotalReceived ();
  int getPortRoute (mt_Route*route, mt_Node*_switch, int port);
  int getSnakeyRoute (mt_Route*route, mt_Node*_switch);
  int getDeadlockRoute (mt_Route*route, mt_Node*_switch, int port);
  int wait (int timeout);
  int waitForReceives ();
  int waitForSends ();
  int getCounts (int*counts);
};

#endif /*sw_Sender_h*/
