/*
  sw_PortSender.c
  "port sender"
  finucane@myri.com (David Finucane)
*/

#include "sw_PortSender.h"
#include "insist.h"

sw_PortSender::sw_PortSender (mt_Job*job, mt_Network*network, mt_Graph*graph, mt_Node*_switch, int receiveWait, int sendWait, int port, int length, int count) : sw_Sender (job, network, graph, receiveWait, sendWait)
{
  this->length = length;
  this->_switch = _switch;
  this->port = port;
  this->count = count;
}

int sw_PortSender::startThread ()
{
  mt_Route r;

  insist (this);
  insist (length > 0 && length <= mt_Network::MTU);
  insist (count >= 0);
  
  if (!sw_Sender::startThread ())
    return 0;
  
  if (receiveWait)
  {  
    if (!getSwitchRoute (&r, _switch, port))
      return 0;
  }
  else
  {
    if (!getPortRoute (&r, _switch, port))
      return 0;
  }
  
  for (int i = 0; i < count; i++)
  {
    mt_ProbeMessage m (0, 0);
    m.swap ();

    if (!sendProbe (&r, &m, length))
    {
      printFormat ("sendProbe failed");
      return 0;    
    }
  }

  if (receiveWait)
    waitForReceives ();
  else waitForSends ();
  
  return !receiveWait || getNumSent () == getNumReceived ();
  exception: return 0;
}

