/*
  sw_ImpedenceReader.c
  finucane@myri.com
*/

#include "sw_ImpedenceReader.h"
#include "insist.h"

sw_ImpedenceReader::sw_ImpedenceReader (int xbar, sw_TestPort*port)
{
  insist (this && port);
  this->xbar = xbar;
  this->port = port;
  count = 0;
  
  exception:;
}

int sw_ImpedenceReader::startThread ()
{
  insist (this);

  char low1, low2, high1, high2;
    
  if (!port->getOutputImpedence (xbar, &low1, &high1, &low2, &high2))
    return 0;
    
  while (!isStopped ())
    if (!port->setOutputImpedence (xbar, low1, high1, low2, high2))
      return 0;
    else count++;
  
  return 1;
  exception: return 0;
}
  
int sw_ImpedenceReader::getCount ()
{
  insist (this);
  return count;
  exception: return 0;
}
