/*
  sw_DeadlockSender.c
  "port sender"
  finucane@myri.com (David Finucane)
*/

#include "sw_DeadlockSender.h"
#include "insist.h"

sw_DeadlockSender::sw_DeadlockSender (mt_Job*job, mt_Network*network, mt_Graph*graph, mt_Node*_switch, int port) : sw_Sender (job, network, graph, 0, 0)
{
  this->_switch = _switch;
  this->port = port;
  duration = 0;
}

int sw_DeadlockSender::getDuration ()
{
  insist (this);
  return duration;
  exception: return 0;
}

int sw_DeadlockSender::startThread ()
{
  mt_ProbeMessage m (0, 0);
  mt_Route r1, r2;

  insist (this);
  
  if (!sw_Sender::startThread ())
    return 0;
 
  if (!getDeadlockRoute (&r1, _switch, port) || !getSwitchRoute (&r2, _switch, port))
    return 0;

  mt_Node*fn;
  int fin;
  
  insist (job->getNode ()->follow (&r1, &fn, &fin) && fn != job->getNode ());
  insist (job->getNode ()->follow (&r2, &fn, &fin) && fn == job->getNode ());

  m.swap ();

  mt_Int64 start, stop;
  start = network->getCurrentTime ();  

  receiveWait = 0;
  sendWait = 1;

  if (!sendProbe (&r1, &m, mt_Network::MTU))
    return 0;

  numReceived = numSent = 0;
  for (int i = 0; i < 1000 && numReceived == 0; i++)
  {
    numSent = numReceived = 0;
  
    if (!sendProbe (&r2, &m, 1))
      return 0;

    wait (100);
  }
  
  stop = network->getCurrentTime ();
  duration = (int) (stop - start) / 2;
  return 1;
  exception: return 0;
}
