#include <stdio.h>
#include <stdlib.h>

#include "mt_MapFile.h"
#include "sw_PortSender.h"
#include "sw_Sender.h"
#include "sw_Test16.h"

#define die(s){mt_Component::printFormat s; exit (1);}
#define call(e)   t++; r += e; if (lazy && t != r) goto the_end

static void printLine (char*s)
{
  printf ("%s\n", s);
}
extern int egretSents;

int main (int argc, char*argv [])
{
  mt_Component::initialize (printLine);
  char*mapFile = argv [2];
  char*hostname = argv [3];
  char*switchname = argv [4];
  char*switchmapname = argv [5];
  char*portString = argv [6];
  char*sizeString = argv [7];
  char*countString = argv [8];
  mt_Node*h;
  mt_Node*s;
  int unit;
  int port;
  
  if (argc != 9) die (("usage: %s <unit> <map file> <host> <switchname> <switch-map-name> <port> <size> <count>", argv [0]));

  mt_MapFile mf (mapFile, mt_File::_READ);
  mt_Graph graph;
  
  unit = atoi (argv [1]);
  
  if (!mf.read (&graph))
    die (("couldn't parse map file %s", mapFile));

  if (!(h = graph.getNode (hostname)) || !h->isHost ())
    die (("%s is not a host in map file %s", hostname, mapFile));
  
  if (!(s = graph.getNode (switchmapname)) || !s->isSwitch ())
    die (("%s is not a switch in map file %s", switchmapname, mapFile));
  
  port = atoi (portString);
  
  if (port < 0 || port >= 16)
    die (("%s a bad port", portString));

  int xbar, numReceived;
  xbar = 0;
  numReceived = 0;
  
  sw_TestPort testPort (switchname);
  sw_Test16 test (unit, &graph, mt_getNetwork (), h, &testPort, 1, &s, 1, 0, 0);
  if (!test.send (xbar, 1, 0, port, atoi (sizeString),  atoi (countString), &numReceived))
  {
    mt_Component::printFormat ("%d / %d received in all", sw_Sender::getTotalReceived (), sw_Sender::getTotalSent ());
    die (("send failed"));
  }
  
  mt_Component::printFormat ("%d / %d received in all", sw_Sender::getTotalReceived (), sw_Sender::getTotalSent ());
  
  return 0;
}
