/*
  st_Simulation.c
  myricom mapper
  finucane@myri.com
*/

#include <string.h>

#include "insist.h"
#include "st_Simulation.h"
#include "st_Mapper.h"
#include "mt_Responder.h"

st_Simulation::st_Simulation ()
{
  numHosts = 0;
}

mt_Job*st_Simulation::newJob (mt_Node*node, mt_Network*network, mt_Calculator*calculator)
{
  if ((!numHosts++ && !*options.mapperName) || !strcmp (node->getName (), options.mapperName))
  {
    strncpy (options.mapperName, node->getName (), mt_Node::NAME_LENGTH);
    return new st_Mapper (node, network, calculator, options);
  }
  else 
    return new mt_Responder (node, network);
}

void st_Simulation::usage ()
{
  options.usage ();
}

int st_Simulation::parseArgs (mt_Args*args)
{
  return options.parseArgs (args);
}

