/*
  st_MapperModule.c
  myricom mapper
  finucane@myri.com (David Finucane)
*/

#include "insist.h"
#include "st_MapperModule.h"
#include "st_Mapper.h"


st_MapperModule::st_MapperModule () : fake ("-", "-")
{
  mapper = 0;
}

st_MapperModule::~st_MapperModule ()
{
  cleanup ();
}

int st_MapperModule::parseArgs (mt_Args*args)
{
  return options.parseArgs (args);
}

void st_MapperModule::usage ()
{
  options.usage ();
}

int st_MapperModule::initialize (mt_Network*network, mt_Calculator*calculator)
{
  mapper = new st_Mapper (&fake, network, calculator, options);
  insistp (mapper, ("mt_MapperModule::initialize: alloc failed"));
  return 1;
  exception: return 0;  
}

int st_MapperModule::start ()
{
  insist (this);
  insist (mapper);
  return mapper->start ();
  exception: return 0;
}

void st_MapperModule::cleanup ()
{
  insist (this);
  if (mapper)
    delete mapper;
  mapper = 0;
  exception: return;
};
