/*
  pi_Simulation.c
  myricom mapper
  finucane@myri.com
*/

#include <string.h>

#include "insist.h"
#include "pi_Simulation.h"
#include "pi_Ping.h"
#include "mt_Responder.h"

pi_Simulation::pi_Simulation ()
{
  numHosts = 0;
  *mapperName = 0;
}

mt_Job*pi_Simulation::newJob (mt_Node*node, mt_Network*network, mt_Calculator*calculator)
{
  if ((!numHosts++ && !*mapperName) || !strcmp (node->getName (), mapperName))
  {
    strncpy (mapperName, node->getName (), mt_Node::NAME_LENGTH);
    return new pi_Ping (node, network, calculator, &options);
  }
  else 
    return new mt_Responder (node, network);
}

void pi_Simulation::usage ()
{
  options.usage ();
}


int pi_Simulation::parseArgs (mt_Args*args)
{
  return options.parseArgs (args);
}
  



