/*
  pi_Ping.h
  map tools
  finucane@myri.com (David Finucane)
*/

#include "mt_Job.h"
#include "mt_Module.h"
#include "mt_Network.h"
#include "mt_Graph.h"
#include "mt_Message.h"
#include "mt_Queue.h"
#include "pi_Options.h"
#include "mt_Switch.h"
#include "de_Deadlock.h"

class pi_Ping;

typedef void (pi_Ping::*pi_MessageHandler)(mt_Node*n, int from, int to, char*p, int length);


class pi_Queue : mt_Component
{
  private:

  class pi_Phase : mt_Component
  {
    public:
    mt_Node*node;
    int phase;
    int from;
    int to;
  };

  int head, tail, size;
  pi_Phase*phases;
    
  public:
  pi_Queue (int size);
  ~pi_Queue ();
  int clear ();
  int empty ();
  int full ();
  int put (mt_Node*node, int phase, int from, int to);
  int get (mt_Node**node, int*phase, int*from, int*to);
  int peek (mt_Node**node, int*phase, int*from, int*to);
  int peek ();
};


class pi_Counter : mt_Component
{
  public:
  mt_Node*node;

  int firstPhases [mt_Switch::NUM_PORTS] [mt_Switch::NUM_PORTS];
  int lastPhases [mt_Switch::NUM_PORTS] [mt_Switch::NUM_PORTS];
  int sent [mt_Switch::NUM_PORTS] [mt_Switch::NUM_PORTS];
  int received [mt_Switch::NUM_PORTS] [mt_Switch::NUM_PORTS];
  
  public:
  pi_Counter ();
  int print (mt_Node*myself, int xbars);
  int addSent (int from, int to);
  int addReceived (int from, int to);
  int setNode (mt_Node*n);
  mt_Node*getNode ();
  int setFirstPhase (int from, int to, int phase);
  int setLastPhase (int from, int to, int phase);
  int getPort (int phase, int*from, int*to);
};

class pi_Ping : public mt_Job
{
  private:
  
  pi_Options options;
  mt_Calculator*calculator;
  mt_Graph graph;
  de_Deadlock deadlock;
  mt_Node*node;
  mt_Node*myself;
  mt_Network*network;
  mt_Route route;
  pi_MessageHandler handlers [mt_Message::NUM_TYPES];
  int mtu;
  char buffer [mt_Network::MTU];
  int currentHost;
  mt_Node*currentSwitch;
  pi_Queue*phases;
  pi_Queue*ports;
  mt_Queue switches;
  pi_Counter*counters;
  int numNodesSeen;
  int numCounters;
  int numSent;
  int numReceived;
  mt_Node*expectedNode;
  int expectedTo;
  int expectedFrom;
  int numBadPhases;
  
  int phase;
  mt_Address address;
  int minPort;
  int maxPort;
  int currentPort;
  int sourcePort;
  
  void handleReply (mt_Node*n, int from, int to, char*p, int length);
  void handleProbe (mt_Node*n, int from, int to, char*p, int length);
  int send (mt_Route*route, char*p, int length);
  int wait (int event, int type, char**p, int*length);
  int wait (int timeout);
  int initialize ();
  int setHandler (int type, pi_MessageHandler handler);
  int clearHandler (int type);
  char*getNextMessage (int*length, mt_Route*r);
  int setPhase (char*p, int phase);
  int addBadPhase (mt_Node*node, int from, int to);
  int startLoopVariables ();
  int computeSwitchRoutes ();
  int ping ();
  int fillFast (char*p, int length);
  int fillSlow (char*p, int length);
  void printPacket (char*p, int length);
  
  public:
  pi_Ping (mt_Node*node, mt_Network*network, mt_Calculator*calculator, pi_Options*options);
  pi_Ping (mt_Node*node, mt_Network*network, mt_Graph*graph, pi_Options*options);

  ~pi_Ping ();
  int print (int interrupted = 0);
  virtual void dump (FILE*fp);
  virtual int willWait ();
  virtual int start ();
  virtual void receive (int event, char*p, int length);
};
