/*
  mm_Node.c
  myricom mapper
  finucane@myri.com (David Finucane)
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "insist.h"
#include "mm_Node.h"
#include "mm_Host.h"

mm_Node*mm_Node::disconnected;
  
mm_Node::mm_Node (char*name, char*type): mt_Node (name, type)
{
  nextNode = 0;
}

int mm_Node::getMaxStringLength ()
{
  insist (this);
  return mt_Node::getMaxStringLength () + 4 * 20;
  exception: return 0;
}

int mm_Node::isConnected ()
{
  insist (this);
  insist (disconnected);
  
  return this != (mm_Node*) disconnected;
  exception: return 0;
}

void mm_Node::setDisconnected ()
{
  if (!disconnected)
    disconnected = new mm_Host ();
}
void mm_Node::setNextNode (mm_Node*n)
{
  this->nextNode = n;
}
mm_Node*mm_Node::getNextNode ()
{
  return nextNode;
}

int mm_Node::getFirst ()
{
  return 0;
}

void mm_Node::setFirst (int first)
{
  insist (first == 0);
  exception:;
}

int mm_Node::shift (int n)
{
  return n - getFirst ();
}
