/*
  mm_Mapper.c
  myricom mapper
  finucane@myri.com (David Finucane)
*/

#ifndef mm_Mapper_h
#define mm_Mapper_h

#include "mt_Mapper.h"
#include "mt_HostTable.h"
#include "mt_Queue.h"

#include "mm_Simulation.h"
#include "mm_Graph.h"
#include "mm_Switch.h"

class mm_Mapper;

typedef void (mm_Mapper::*mm_MessageHandler)(mt_Message*m, int length);

class mm_Mapper : public mt_Mapper
{
  private:
  mm_MessageHandler handlers [mt_Message::NUM_TYPES];
  volatile int done;
  volatile int active;
  int phase;
  mt_Address address;
  int gmId;
  int hostType;
  char hostname [mt_Network::HOSTNAME_LENGTH + 1];
  mt_Queue queue;
  mm_Graph*oldGraph;
  mm_Graph*currentGraph;
  mm_Switch*currentSwitch;
  volatile int duplicate;
  mm_Switch*previousSwitch;
  mm_Switch*candidateSwitch;
  mm_Node*mergeList;
  int depth;
  
  mm_Graph*map (int mapVersion, int depth);
  
  int firstHost (mm_Graph*graph);
  mm_Switch*firstSwitch (mm_Graph*graph);
  int findHosts (mm_Switch*s);
  void explore (int depth);
  
  void setHandler (int type, mm_MessageHandler handler);
  void nullHandler (mt_Message*m, int length);
  void handleScout (mt_Message*m, int length);
  void handleReply (mt_Message*m, int length);
  void handleLoopProbe (mt_Message*m, int length);
  void findLoops (mm_Switch*s);
  void handleSwitchProbe (mt_Message*m, int length);
  void findSwitches (mm_Switch*s);
  void handleCompare (mt_Message*m, int length);
  int notUnique (mm_Switch*a, mm_Switch*b);
  int unique (mm_Switch*s);
  int merge (int alignment, mm_Switch*s1, mm_Switch*s2);
  int merge (mt_Graph*graph, int alignment, mm_Switch*s1, mm_Switch*s2);
  
  void handleIdProbe (mt_Message*m, int length);
  mm_Switch*firstIdProbe (mm_Graph*graph);
  void findSwitchesIdProbe (mm_Switch*s);
  mt_Node*getRememberedNode (mt_Route*r);
  int measureLatencies (mt_Graph*g, int*hostLatency, int*switchLatency);

  public:
  mm_Mapper (mt_Node*node, mt_Network*network, mt_Calculator*calculator,
	     mt_MapperOptions&options);
  virtual void clearHandler (int type);
  virtual void callHandler (int type, mt_Message*m, int length);
  virtual mt_Node*newNode (int nodeType, char*name, char*type);
  
  virtual ~mm_Mapper ();
  
  virtual void dump (FILE*fp);
  virtual int start ();
};


#endif /*mm_Mapper_h*/
