/*
  mm_Host.h
  myricom mapper
  finucane@myri.com (David Finucane)
*/

#ifndef mm_Host_h
#define mm_Host_h

#include "mm_Node.h"
#include "mt_Address.h"
#include "mt_Network.h"

class mm_Host : public mm_Node
{
  public:
  
  private:
  mm_Node*node;
  int opposite;
  int dead;
  int gmId;
  int missing;
  
  mt_Address address;
  int control;
  int hostType;
  char hostname [mt_Network::HOSTNAME_LENGTH + 1];
  
  public:
  mm_Host (char*name, char*hostType);
  mm_Host (char*name, int hostType);
  mm_Host ();
  ~mm_Host ();
    
  int isDead ();
  void setDead (int dead);
  virtual void setAddress (mt_Address*address);
  virtual int getControl ();
  virtual int setControl (int control);
  virtual void setMissing (int missing);
  virtual int getMissing ();
    
  virtual void setGmId (int gmId);
  virtual int getGmId ();
  virtual int getHostType ();
  virtual void setHostType (int hostType);
  virtual void disconnect (int p);
  virtual mm_Node*mGetNode (int p);
  virtual int mGetOpposite (int p);
  virtual void mConnect (int p, int o, mm_Node*n);
  virtual mt_Address*getAddress ();
  virtual int getNodeType ();
  virtual int getMaxNodes ();
  virtual mt_Node*getNode (int p);
  virtual int getOpposite (int p);
  virtual void connect (int p, int o, mt_Node*n);
  virtual int setOption (char*option, char*value);
  virtual char*toString (char*s);
};

#endif /*mm_Host_h*/
