/*
  mm_Host.c
  myricom mapper
  finucane@myri.com (David Finucane)
*/

#include <stdio.h>
#include <string.h>

#include "insist.h"
#include "mm_Host.h"

mm_Host::~mm_Host ()
{
}

int mm_Host::getNodeType ()
{
  return mt_Node::HOST;
}

int mm_Host::getMaxNodes ()
{
  return 1;
}

mm_Host::mm_Host (char*name, int hostType) : mm_Node (name, "-")
{
  node = 0;
  opposite = -1;
  this->hostType = hostType;
  missing = 0;
}

mm_Host::mm_Host () : mm_Node ("_", "-")
{
  node = 0;
  opposite = -1;
}

mm_Host::mm_Host (char*name, char*type) : mm_Node (name, type)
{
  node = 0;
  opposite = -1;
}

void mm_Host::disconnect (int p)
{
  insist (this);
  insist (!p);
  
  node = mm_Node::disconnected;
  
  exception: return;
}

void mm_Host::mConnect (int p, int o, mm_Node*n)
{
  insist (this);
  insist (!p && n);

  node = n;
  opposite = o;
  
  exception: return;
}

int mm_Host::mGetOpposite (int p)
{
  insist (this);
  insist (!p);
  return opposite;
  exception: return -1;
}

mm_Node*mm_Host::mGetNode (int p)
{
  insist (this);
  insist (!p);
  return node;
  exception: return 0;
}

void mm_Host::connect (int p, int o, mt_Node*n)
{
  insist (this);
  insist (!p);

  mm_Node*m;
  m = (mm_Node*)n;
  node = m;

  opposite = o + m->getFirst ();
  
  exception: return;
}

mt_Node*mm_Host::getNode (int p)
{
  insist (this);
  insist (!p);
  return node && node->isConnected () ? node : 0;
  exception: return 0;
}

int mm_Host::getOpposite (int p)
{
  insist (this);
  insist (!p);

  insist (node);
  
  return node->shift (opposite);
  exception: return -1;
}

int mm_Host::getGmId ()
{
  insist (this);
  return gmId;
  exception: return 0;
}

void mm_Host::setGmId (int gmId)
{
  insist (this);
  this->gmId = gmId;
  exception: return;
}

int mm_Host::setOption (char*option, char*value)
{
  insist (this);
  insist (option && value);
  return 1;
  exception: return 0;
}

int mm_Host::isDead ()
{
  insist (this);
  return dead;
  exception: return 0;
}

void mm_Host::setDead (int dead)
{
  insist (this);
  this->dead = dead;
  exception: return;
}

mt_Address*mm_Host::getAddress ()
{
  insist (this);
  return &this->address;
  exception: return 0;
}

void mm_Host::setAddress (mt_Address*address)
{
  insist (this);
  insist (address);
  this->address = *address;
  exception: return;
}

int mm_Host::getHostType ()
{
  insist (this);
  return hostType;
  exception: return 0;
}

char*mm_Host::toString (char*s)
{
  insist (this);
  insist (s);

  char buffer [30];
  
  char*t;
  t = s;

  s += strlen (mt_Node::toString (s));
  s += sprintf (s, "address %s\n", address.toString (buffer));
  s += sprintf (s, "gmId %d\n", gmId);
  s += sprintf (s, "hostType %d\n", hostType);
  
  return t;
  exception: return 0;
}

/*
int mm_Host::shift (int n)
{
  insist (this);
  if (n)
    return -1;
  
  return 0;
  exception: return -1;
}
*/


int mm_Host::getControl ()
{
  insist (this);
  return control;
  exception: return 0;
}

int mm_Host::setControl (int control)
{
  insist (this);
  this->control = control;
  return 1;
  exception: return 0;
}


void mm_Host::setHostType (int hostType)
{
  insist (this);
  this->hostType = hostType;
  exception:;
}

void mm_Host::setMissing (int missing)
{
  insist (this);
  this->missing = missing;
  exception:;
}

int mm_Host::getMissing ()
{
  insist (this);
  return missing;
  exception: return 0;
}
