/*
  mm_Graph.h
  myricom mapper
  finucane@myri.com (David Finucane)
*/

#ifndef mm_Graph_h
#define mm_Graph_h

#include "mt_Graph.h"
#include "mm_Host.h"
#include "mm_Switch.h"

class mm_Graph : public mt_Graph
{
  private:
  char switchNameBuffer [mt_Node::NAME_LENGTH + 1];
  int numSwitchesMade;
  static int version;
  int mapVersion;
  
  public:
  mm_Graph ();
  ~mm_Graph ();
  static void clearVersion ();
  char*makeSwitchName ();
  int getMapVersion ();
  void setMapVersion (int mapVersion);
  int finishSwitches ();
  mm_Switch*getSwitchFromId (int id);
  
  virtual mt_Node*newNode (int nodeType, char*name, char*type);
};


#endif /*mm_Graph_h*/



