/*
  mm_Graph.c
  myricom mapper
  finucane@myri.com (David Finucane)
*/


#include "insist.h"
#include "mm_Graph.h"
#include "mm_Switch.h"
#include "mm_Host.h"

int mm_Graph::version;

void mm_Graph::clearVersion ()
{
  version = 0;
}

mm_Graph::~mm_Graph ()
{
}


mt_Node*mm_Graph::newNode (int nodeType, char*name, char*type)
{
  mt_Route r;
  
  insist (this);

  switch (nodeType)
  {
    case mt_Node::HOST:
      return new mm_Host (name, type);
    case mt_Node::SWITCH:
      return new mm_Switch (name, &r);
    default:
      insist (0);
  }
  exception: return 0;
}

 
mm_Graph::mm_Graph ()
{
  mapVersion = ++version;
  numSwitchesMade = 0;
}


int mm_Graph::getMapVersion ()
{
  insist (this);
  return mapVersion;
  exception: return 0;
}
void mm_Graph::setMapVersion (int mapVersion)
{
  insist (this);
  this->mapVersion = version = mapVersion;
  exception: return;
}

char*mm_Graph::makeSwitchName ()
{
  insist (this);
  
  sprintf (switchNameBuffer, "s%d", numSwitchesMade++);
  return switchNameBuffer;
  
  exception: return 0;
}

mm_Switch*mm_Graph::getSwitchFromId (int id)
{
  insist (this);
  insist (id);

  int numSwitches;
  numSwitches = getNumSwitches ();
  
  for (int i = 0; i < numSwitches; i++)
  {
    mm_Switch*s = (mm_Switch*) getSwitch (i);
    insist (s);
    
  if (s->getId () == id)
      return s;
  }
  exception: return 0;
}

int mm_Graph::finishSwitches ()
{
  insist (this);

  int numSwitches;
  numSwitches = getNumSwitches ();
  
  for (int i = 0; i < numSwitches; i++)
  {
    mm_Switch*s = (mm_Switch*) getSwitch (i);
    insist (s);
    s->finish ();
  }
  
  return 1;
  exception: return 0;
}
