/*
  mm_Cloud.h
  myrinet mapper
  finucane@myri.com (David Finucane)
*/

#ifndef mm_Cloud_h
#define mm_Cloud_h

#include "mm_Node.h"
#include "mt_Graph.h"

class mm_Cloud : public mm_Node
{  
  private:
  mm_Node**nodes;
  int opposite;
  int numNodes;
  mt_Address address;
  int hostType;
  
  public:
  mm_Cloud (mt_Address*a, mt_Route*r, int numNodes);
  
  ~mm_Cloud ();
  virtual void disconnect (int p);

  virtual mm_Node*mGetNode (int p);
  virtual int mGetOpposite (int p);
  virtual void mConnect (int p, int o, mm_Node*n);
  virtual mt_Address*getAddress ();
  virtual int getHostType ();
  
  virtual char*toString (char*s);
  virtual int getNodeType ();
  virtual int getMaxNodes ();
  virtual mt_Node*getNode (int p);
  virtual int getOpposite (int p);
  virtual void connect (int p, int o, mt_Node*n);
};
  
#endif /*mm_Cloud_h*/


