/*
  Tablet.java
  Merlyn
  (c) 1997 Myricom, Inc.
  finucane@myri.com (David Finucane)
*/

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

public class Tablet extends Canvas implements MouseMotionListener,
MouseListener, KeyListener, ActionListener, ItemListener
{
  private Anatomy anatomy;
  private Anatomy groups [];
  private Image image;
  private Switch glowingSwitch;
  private Node selectedNode;
  private Edge selectedEdge;
  private Edge movingEdge;
  private Point pressedDelta = new Point (0,0);
  private int selectedPort = -1;
  private Node routeNode;
  private boolean routesOn = false;
  private Rectangle drag = new Rectangle (-1,-1,0,0);
  private boolean justDragged = false;
  private Anatomy compare;
  private boolean comparing = false;
  private boolean showGroups = false;
  private PopupMenu groupMenu;
  private MenuItem groupItem;
  private MenuItem flipItem;
  private CheckboxMenuItem neverSendItem;
  private CheckboxMenuItem neverReceiveItem;
  private MenuItem ports8Item;
  private MenuItem ports16Item;
  private MenuItem frontItem;
  private MenuItem backItem;
  private MenuItem ungroupItem;
  private MenuItem groupItems[];
  private int numGroups;
  private NodeListener nodeListener;
  private int curMouseX=-1, curMouseY=-1;
  private boolean hideHosts;
  
  public Tablet (String groupNames [], Anatomy groups [])
  {
    anatomy = new Anatomy ();
    this.groups = groups;
    
    groupMenu = new PopupMenu ();
    groupMenu.add (flipItem = new MenuItem ("Flip"));
    groupMenu.add (frontItem = new MenuItem ("Bring to Front"));
    groupMenu.add (backItem = new MenuItem ("Send to Back"));
    groupMenu.add (neverSendItem = new CheckboxMenuItem ("neverSend"));
    groupMenu.add (neverReceiveItem = new CheckboxMenuItem ("neverReceive"));
    groupMenu.add (ports8Item = new MenuItem ("8 ports"));
    groupMenu.add (ports16Item = new MenuItem ("16 ports"));
    groupMenu.add (groupItem = new MenuItem ("Group"));
    groupMenu.add (ungroupItem = new MenuItem ("Ungroup"));

    if (groupNames != null)
    {
      numGroups = groupNames.length;
      groupItems = new MenuItem [numGroups];
      
      for (int i = 0; i < numGroups; i++)
      {
	groupMenu.add (groupItems[i] = new MenuItem (groupNames [i]));
	groupItems[i].addActionListener (this);
      }
    }
    neverSendItem.addItemListener (this);
    neverReceiveItem.addItemListener (this);
    flipItem.addActionListener (this);
    frontItem.addActionListener (this);
    ports8Item.addActionListener (this);
    ports16Item.addActionListener (this);
    backItem.addActionListener (this);
    groupItem.addActionListener (this);
    ungroupItem.addActionListener (this);
    add (groupMenu);
    
    addMouseMotionListener (this);
    addMouseListener (this);
    addKeyListener (this);
    setBackground (Color.white);
  }
  public void toFile (String filename)
  {
    try
      {
	FileOutputStream out = new FileOutputStream (filename);
	String s = anatomy.toString();

	byte[] bytes = s.getBytes ();
	out.write (bytes);
	out.close();
      }
    catch (Exception ex)
      {
	System.out.println (ex);
      }
  }
  public void setShowGroups (boolean on)
  {
    Node.setShowGroups (showGroups = on);
    repaint ();
  }
  public void setHideHosts (boolean hideHosts)
  {
    Node.hideHosts = this.hideHosts = hideHosts;
    repaint ();
  }
  public boolean getPositioned ()
  {
    return anatomy.getPositioned ();
  }
  public boolean isSwitchSelected()
  {
    return anatomy.isSwitchSelected();
  }
  public String getSelectedSwitchesString()
  {
    return anatomy.getSelectedSwitchesString();    
  }
  // Output selected switches to file (to become root)
  public boolean sss (String filename)
  {
    try
      {
	FileOutputStream out = new FileOutputStream (filename);
	String s = anatomy.sssToString();
	if (s == null)
	  return false;
	
	byte[] bytes = s.getBytes ();
	out.write (bytes);
	out.close();
	return true;
      }
    catch (Exception ex)
      {
	System.out.println (ex);
	return false;
      }
  }
  public void deleteSelectedNodes ()
  {
    if (routeNode != null && routeNode.getSelected ())
      routeNode = null;
    anatomy.removeSelectedNodes ();
    anatomy.setHighestErrorFigure ();
    selectedNode = null;
    glowingSwitch = null;
  }
  public Node getSelectedNode ()
  {
    return selectedNode;
  }
  private void deleteSelectedEdge ()
  {
    anatomy.remove (selectedEdge);
    setSelectedEdge (null);
  } 
  private void setSelectedEdge (Edge e)
  {
    if (selectedEdge != null)
      selectedEdge.setSelected (false);
    selectedEdge = e;
    if (e != null)
      selectedEdge.setSelected (true);
    repaint ();
  }
  private boolean isPopupTrigger (MouseEvent e)
  {
    int x = e.getX ();
    int y = e.getY ();
    Node n = anatomy.getNode (x, y);

    return (e.isPopupTrigger() || e.isControlDown()) && n != null && n.getSelected ();
  }
  public void addNodeListener (NodeListener listener)
  {
    nodeListener = listener;
  }
  public void mousePressed (MouseEvent e)
  {
    requestFocus();
    
    
    int x = e.getX ();
    int y = e.getY ();

    if (isPopupTrigger (e))
    {
      Node n = anatomy.getNode (x, y);

      neverSendItem.setState (n.neverSend);
      neverReceiveItem.setState (n.neverReceive);
      
      groupMenu.show (this, x, y);
    }
    
    if (anatomy.handleClick(x,y))
    {
      repaint();
      return;
    }
    
    anatomy.setEditLabel(null);
    Node n = anatomy.getNode (x, y);
    Edge edge = null;
    selectedPort = -1;
    movingEdge = null;

    if (n == null)
    {
      if (Node.showLabels())
	n = anatomy.getNodeLabel(x, y);
      
      if (n != null)
	anatomy.setEditLabel(n);
      else
	edge = anatomy.getEdge (x, y);
    }
    if (n != null)
    {
      pressedDelta.x = x - n.getX();
      pressedDelta.y = y - n.getY();

      if (!e.isShiftDown() && (!justDragged || !n.getSelected()))
	unselect();

      if (e.isShiftDown() && n.getSelected())
      {
	n.setSelected (false);
	selectedNode = null;
	repaint();
	return;
      }

      if (n instanceof Switch)
      {
	selectedPort = ((Switch)n).getPosition (x, y);
	if (selectedPort != -1 && e.isShiftDown())
	  {
	    ((Switch)n).toggleLan(selectedPort);
	    repaint();
	    return;
	  }
	if (selectedPort != -1 && n.getEdge (selectedPort) == null)
	  movingEdge = new Edge (x, y);
      }
      else if (n instanceof Cloud)
      {
	
      }
      else if (routesOn && e.isShiftDown())
      {
	anatomy.eraseRoutes ();
	if (routeNode != n && routeNode != null)
	  routeNode.setRedSquare (false);
	routeNode = n;
	  routeNode.setRedSquare (true);
      }
      else if (routesOn && !e.isShiftDown() && routeNode != null)
      {
	((Host)n).toggleRoute ((Host)routeNode);
      }
    }
    else
    {

    }

    // Either selects the edge or deselects the current edge
    setSelectedEdge (edge);

    if (!justDragged || n == null)
      unselect ();

    if (n != null)
    {
      n.setSelected (true);
    }
    
    selectedNode = n;

    if (n == null)
    {
      justDragged = false;
      drag.x = x;
      drag.y = y;
      drag.width = drag.height = 0;
    }
    
    repaint ();
  }
  public void mouseReleased (MouseEvent e)
  {
    int x = e.getX ();
    int y = e.getY ();

    if (anatomy.editLabelVisible())
      {
	if (anatomy.handleDrag(x, y))
	  repaint();
	return;
      }

    justDragged = true;
    drag.x = drag.y = -1;
    drag.width = drag.height = 0;
    
    if (movingEdge != null)
    {
      Node n = anatomy.getNode (x, y);
      int p = -1;
      
      if (n != null && n != selectedNode)
      {        
        if (n instanceof Host)
        {
          if (n.getEdge (0) == null)
            p = 0;
        }
        else
        {
          p = ((Switch)n).getPosition (x, y);
          if (p != -1 && n.getEdge (p) != null)
            p = -1;
        }
      }
      
      if (p != -1 && n != null)
      {
        Edge edge = new Edge (selectedNode, n, selectedPort, p);
        n.connect (edge, p);
        selectedNode.connect (edge,selectedPort);
        anatomy.add (edge);
      }
      movingEdge = null;
    }
    repaint ();
  }
  private void moveSelected (int dx, int dy)
  {
    anatomy.moveSelected (dx, dy);
    repaint ();
  }
  public void mouseDragged (MouseEvent e)
  { 
    int x = e.getX ();
    int y = e.getY ();

    if (anatomy.editLabelVisible())
      {
	if (anatomy.handleDrag(x, y))
	  repaint();
	return;
      }

    glowPort (x, y);
    
    if (movingEdge != null)
      movingEdge.move (x, y);
    else if (drag.x == -1 && selectedNode != null)
    {
      if (anatomy.getNumSelectedNodes () == 1)
      {
	Object group = selectedNode.getGroup();
	if (group != null && e.isShiftDown())
	{
	  int dx = x - pressedDelta.x - selectedNode.getX();
	  int dy = y - pressedDelta.y - selectedNode.getY();
	  
	  Node gn[] = anatomy.getGroupedNodes (group);
	  for (int i = 0; i < gn.length; i++)
	    gn[i].moveGroup (gn[i].getX() + dx, gn[i].getY() + dy);
	}
	else selectedNode.moveGroup (x - pressedDelta.x, y - pressedDelta.y);
      }
      else
	moveSelected (x - pressedDelta.x - selectedNode.getX(),
		      y - pressedDelta.y - selectedNode.getY());
    }
    else if (drag.x >= 0)
    { 
      drag.width = x - drag.x;
      drag.height = y - drag.y;

      int tx = drag.x + drag.width;
      int ty = drag.y + drag.height;

      Rectangle d = new Rectangle ((int) Math.min (drag.x, tx),
				   (int) Math.min (drag.y, ty),
				   (int) Math.abs (drag.width),
				   (int) Math.abs (drag.height));
      unselect();
      select (d);
    }
    repaint ();
    
  }
  private void unselect ()
  {
    anatomy.unselect ();
    repaint ();
  }
  private void select (Rectangle r)
  {
    selectedNode = anatomy.select (r);
    repaint();
  }

  public void keyPressed (KeyEvent e)
  {
    if (anatomy.handleKeyPressed (e))
    {
      repaint();
      return;
    }
  }

  public void keyTyped (KeyEvent e)
  {
    if (anatomy.handleKeyTyped (e))
    {
      repaint();
      return;
    }
    char c = e.getKeyChar ();

    if (c == '\b')
    {
      if (selectedNode != null)
	deleteSelectedNodes ();
      else if (selectedEdge != null)
	deleteSelectedEdge ();
      repaint();
    }
    else if (c == 'h')
      newHost(true);
    else if (c == 's')
      newSwitch (true, 8);
    else if (c == 'S')
      newSwitch (true, 16);
  }
  public void mouseMoved (MouseEvent e) 
  {
    curMouseX = e.getX ();
    curMouseY = e.getY ();
    
    glowPort (curMouseX, curMouseY);
  }


  private int glowPort (int x, int y)
  {
    // Fixed to eliminate unnecessary flashing - DMM

    boolean repaint = false;
    Switch oldGlow = glowingSwitch;
    int p;

    if (glowingSwitch != null)
    {
      glowingSwitch.setGlowPoint (-1);
      repaint = true;
    }
    
    Node n = anatomy.getNode (x, y);

    if (n == null || !(n instanceof Switch))
      {
	p = -1;
	glowingSwitch = null;
      }
    else
    {
      p = ((Switch)n).getPosition (x, y);
    
      if (p != -1 && n.getEdge (p) == null)
      {
        glowingSwitch = (Switch) n;
        glowingSwitch.setGlowPoint (p);

	if (glowingSwitch != oldGlow ||
	    (glowingSwitch == oldGlow && p != oldGlow.getGlowPoint()))
          repaint = true;
      }
    }

    if (repaint)
      repaint();

    return p;
  }
  
  public void mouseClicked (MouseEvent e)
  {
  }
  public void mouseEntered (MouseEvent e)
  { 
  }
  public void mouseExited (MouseEvent e)
  { 
  }
  public void keyReleased (KeyEvent e)
  { 
  }
  private void paintOffscreen (Graphics g)
  {
    anatomy.paint (g, hideHosts);
    if (movingEdge != null)
      movingEdge.paint (g);

    g.setColor (Color.gray);
    if (drag.x >= 0)
    {
      int tx = drag.x + drag.width;
      int ty = drag.y + drag.height;

      Rectangle d = new Rectangle (
				   (int) Math.min (drag.x, tx),
				   (int) Math.min (drag.y, ty),
				   (int) Math.abs (drag.width),
				   (int) Math.abs (drag.height));

      g.drawRect (d.x, d.y, d.width, d.height);
    }
  }
  public void setRoutes (boolean b)
  {
    anatomy.eraseRoutes ();
    routeNode = null;
    routesOn = b;
    repaint();
  }
  public void setNumbers (boolean b)
  {
    Edge.setNumbers (b);
    repaint();
  }
  public void setColors (boolean b)
  {
    Edge.setColors (b);
    repaint();
  }
  public void setAllTest (boolean b)
  {
    if (b)
      anatomy.setHighestErrorFigure();
    Edge.setAllTest (b);
    repaint();
  }
  public boolean fromSimulation (String filename)
  {
    boolean deadlocked = false;
    try
      {
	deadlocked = anatomy.fromSimulation (filename);
      }
    catch (Exception ex)
      {
	System.out.println (ex);
      }
    repaint ();
    return deadlocked;
  }
  public void fromFile (String filename)
  {
    anatomy = new Anatomy (filename);
    repaint ();
  }
  public void fromString(String s)
  {
    anatomy = new Anatomy ();
    anatomy.fromString(s);
    repaint ();
  }
  public void setCompare (boolean on)
  {
    comparing = on;
  }
  public void refreshFromString (String s)
  {
    Anatomy knew = new Anatomy ();
    knew.fromString (s);
    refresh (knew);
  }
  public void refreshFromFile (String filename)
  {
    
    refresh (new Anatomy (filename));
  }
  private void refresh (Anatomy knew)
  {
    Anatomy old = (compare != null && comparing ) ? compare : anatomy;
    
    boolean matched;
    
    if (! (matched = Anatomy.match (old, knew) && old != compare))
      matched = Anatomy.match (knew, old);

    //System.out.println ("matched = " + matched );
    
    knew.circle (((ScrollPane)getParent()).getViewportSize());
    if (matched)
    {
      knew.moveMatches ();
      if (!comparing)
      {
	knew.cleanUpHosts ();
	knew.moveMatches ();
      }
      else
      {
	compare.markDead ();
      }
    }
    
    anatomy = comparing ? compare : knew ;
    repaint ();
  }
  public void compareNow ()
  {
    if (compare == null)
    {
      //System.out.println("Nothing to compare with.");
    }
    else
    {
      //System.out.println("Comparing...");
      if (Anatomy.match (compare, anatomy))
      {
	compare.markDead ();
	//System.out.println("matched for compareNow.");
	anatomy = compare;
      }
      repaint ();
    }
  }
  public void readCompare (String filename)
  {
    try
      {
	compare = new Anatomy (filename);
      }
    catch (Exception ex)
      {
	System.out.println (ex);
      }
  }
  public void readRoutes (String filename)
  {
    if (anatomy == null)
      return;
    
    try
      {
	anatomy.readRoutes (filename);
	repaint();
      }
    catch (Exception ex)
      {
	System.out.println (ex);
      }
  }
  public boolean readAllTest (String filename)
  {
    if (anatomy == null)
      return false;
    try
      {
	if (!anatomy.readAllTest (filename))
	  return false;
	repaint();
      }
    catch (Exception ex)
      {
	System.out.println (ex);
	return false;
      }
    return true;
  }
  public void update (Graphics g)
  {
    paint (g);
  }
  public synchronized void invalidate ()
  {
    image = null;
    System.gc ();
    super.invalidate ();
  }
  public void paint (Graphics g)
  {
    if (image == null)
      image = createImage (getBounds().width, getBounds().height);
    Graphics go = image.getGraphics ();

    go.setColor (Color.white);
    go.fillRect (0, 0, image.getWidth (null), image.getHeight (null));
    
    paintOffscreen (go);
    g.drawImage (image, 0,0, null);
  }
  public void newSwitch (boolean atMouse, int size)
  {
    int x, y;
    
    if (atMouse && curMouseX>=0 && curMouseY>=0)
      {
	x = curMouseX;
	y = curMouseY;
      }
    else
      {
	Dimension d = (getParent()).getSize();
	Point p = (getParent()).getLocation();
	x = d.width/2 + p.x;
	y = d.height/2 + p.y;
      }

    Switch n = new Switch (size, x, y, anatomy.getUniqueSwitchName());
    anatomy.add (n);
    unselect();
    selectedNode = n;
    repaint();
  }
  public void newHost (boolean atMouse)
  {
    int x, y;

    if (atMouse && curMouseX>=0 && curMouseY>=0)
      {
	x = curMouseX;
	y = curMouseY;
      }
    else
      {
	Dimension d = (getParent()).getSize();
	Point p = (getParent()).getLocation();
	x = d.width/2 + p.x;
	y = d.height/2 + p.y;
      }

    Host n = new Host (x, y, anatomy.getUniqueHostName());
    anatomy.add (n);
    unselect();
    selectedNode = n;
    repaint ();
  }
  public void tree (Dimension d)
  {
    Node nodes[] = anatomy.getSelectedSwitchesAndClouds();
    if (nodes.length == 0)
      return;
    anatomy.tree (nodes, d);
    repaint();
  }
  public void levels (Dimension d)
  {
    anatomy.levels (d);
    repaint();
  }
  public synchronized void relax (Dimension d, boolean relaxEdges)
  {
    anatomy.relax (d, selectedNode, relaxEdges);
    repaint ();
  }
  public void circle (Dimension d)
  {
    anatomy.circle (d);
    repaint();
  }
  public void setShowNames (boolean b)
  {
    Node.setShowNames (b);
    repaint();
  }
  public void duplicate ()
  {
    selectedNode = anatomy.duplicateSelectedNodes ();
    repaint();
  }
  public void selectAll ()
  {
    //    requestFocus();
    justDragged = true;
    anatomy.selectAll();
    selectedNode = anatomy.getOneSelectedNode();
    repaint();
  }
  public void selectHosts ()
  {
    //    requestFocus();
    justDragged = true;
    anatomy.selectHosts();
    selectedNode = anatomy.getOneSelectedNode();
    repaint();
  }
  public void selectSwitches ()
  {
    //    requestFocus();
    justDragged = true;
    anatomy.selectSwitches();
    selectedNode = anatomy.getOneSelectedNode();
    repaint();
  }
  public void showNodes (String names[], boolean showRoutes)
  {
    if (anatomy == null || names == null)
      return;
    
    setRoutes (true);
    Node pair [] = anatomy.showNodes (names);
    if (showRoutes &&
	pair != null && pair [0] != null &&
	pair [1] != null &&
	pair [0] instanceof Host && pair[1] instanceof Host)
      ((Host)pair[0]).toggleRoute ((Host)pair[1]);
    
    repaint();
  }
  public synchronized void itemStateChanged (ItemEvent e)
  {
    Object object = (Object) e.getSource();
    boolean on = e.getStateChange() == ItemEvent.SELECTED;
  
    if (object == neverReceiveItem)
      selectedNode.neverReceive = on;
    else if (object == neverSendItem)
      selectedNode.neverSend = on;
  }
  
  public synchronized void actionPerformed (ActionEvent e)
  {
    Object object = e.getSource ();
    
    if (object == flipItem)
    {
      anatomy.flipNodes (anatomy.getSelectedSwitches());
      repaint();
    }
    else if (object == frontItem)
    {
      anatomy.bringSelectedToFront();
      repaint();
    }
    else if (object == backItem)
    {
      anatomy.sendSelectedToBack();
      repaint();
    }
    else if (object == ports8Item)
    {
      anatomy.setSelectedSwitchSize(8);
      repaint();
    }
    else if (object == ports16Item)
    {
      anatomy.setSelectedSwitchSize(16);
      repaint();
    }
    else if (object == groupItem)
    {
      anatomy.groupNodes (anatomy.getSelectedSwitches());
      repaint ();
    }
    else if (object == ungroupItem)
    {
      anatomy.ungroupNodes (anatomy.getSelectedSwitches());
      repaint ();
    }
    else
    {
      for (int i = 0; i < numGroups; i++)
      {
	if (object == groupItems [i])
	{
	  Cursor c = getCursor ();
	  setCursor (Cursor.getPredefinedCursor (Cursor.WAIT_CURSOR));      
	  repaint ();
	  
	  anatomy.autoGroupNodes (groups[i].getNodes(), anatomy.getSelectedSwitches());

	  setCursor (c);
	  repaint ();
	  return;
	}
      }
    }
  }
}



