/*
  Switch.java
  Merlyn
  (c) 1997 Myricom, Inc.
  finucane@myri.com (David Finucane)
*/

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import java.awt.image.*;
import GraphicsUtil;

class Switch extends Node
{
  public final static int MAX_EDGES = 16;
  private int numEdges;
  private static Image images [] = new Image[4];
  private int flip = 0;
  private int glowPoint = -1;
  private boolean lan[];
  
  public Switch (int numEdges, int x, int y, String name)
  {
    super (x, y, name);
    this.numEdges = numEdges;
    edges = new Edge[numEdges];
    bandwidths = new double[numEdges];

    lan = new boolean[MAX_EDGES];
    for(int l=0; l<MAX_EDGES; l++)
      lan[l] = true;

    for (int i = 0; i < numEdges; i++)
      bandwidths[i] = 0;
    
    if (images[0] == null)
    {
      images[0] = loadImage ("switch8a.gif");
      images[1] = loadImage ("switch8b.gif");
      images[2] = loadImage ("switch16a.gif");
      images[3] = loadImage ("switch16b.gif");
    }

    image = images[getImageIndex()];
  }
  private int getImageIndex ()
  {
    if (this.numEdges <= 8)
      return flip; // 8-port image
    else
      return 2+flip; // 16-port image
  }
  public void setNumEdges (int num)
  {
    if (num < 1 || num > Switch.MAX_EDGES)
      return;

    int oldNumEdges = numEdges;
    numEdges = num;
    int min = oldNumEdges < numEdges? oldNumEdges : numEdges;

    Edge newEdges[] = new Edge[numEdges];
    double newBandwidths[] = new double[numEdges];
    boolean newLans[] = new boolean[numEdges];

    for(int i=0; i<min; i++)
    {
      newEdges[i] = edges[i];
      newBandwidths[i] = bandwidths[i];
      newLans[i] = lan[i];
    }
    edges = newEdges;
    bandwidths = newBandwidths;
    lan = newLans;

    image = images[getImageIndex()];    
  }
  public void toggleLan(int portNum)
  {
    lan[portNum] = !lan[portNum];
  }
  public void setLanFromString(String s)
  { 
    for (int i=0; i<s.length(); i++)
      {
	char c = s.charAt(i);
	if (c=='l' || c=='L')
	  lan[i] = true;
	else
	  lan[i] = false;
      }
  }
  public String getLanString()
  {
    String s = "";
    boolean set = false;
    
    for(int i=0; i<this.numEdges; i++)
    {
      if (!lan [i])
	set = true;
      
      s += (lan[i]? 'l': 's');
    }
    
    return set ? s : null;
  }
  public void flip(int newState)
  {
    this.flip = newState;
    image = images[getImageIndex()];
    this.move(x,y);
  }
  public void flip()
  {
    this.flip(1-flip);
  }
  public int getNumEdges ()
  {
    return numEdges;
  }
  public void turnGlowPointOff ()
  {
    glowPoint = -1;
  }
  public void setGlowPoint (int glowPoint)
  {
    this.glowPoint = glowPoint;
  }
  public int getGlowPoint ()
  {
    return this.glowPoint;
  }
  public int getSide (int i)
  {
    return i % numEdges;
  }
  public int getPosition (Edge e)
  {
    for (int i = 0; i < numEdges; i++)
      if (edges[i] == e)
        return i;
    return -1;
  }
  public Rectangle getRectangle (Point p)
  {
    int mn = 6;
    return new Rectangle (p.x - mn/2, p.y - mn/2, mn, mn);
  }
  public Rectangle getRectangle (int p)
  {
    return getRectangle (getPoint (p));
  }
  public int getPosition (int x, int y)
  {
    for (int i = 0; i < numEdges; i++)
      if (getRectangle (i).contains (x,y))
	return i;
    return -1;
  }
  public int getPosition (Host n)
  {
    return getPosition (n.getEdge (0));
  }
  private void cleanUpHost (Host n)
  {
    int i = getPosition (n);
    Point p = getPoint (i);
    int a = n.getSize().width;
    int w = a * 3;
    
    switch (getSide (i))
    {
      case 0:
	n.move (Math.max (p.x - a/2, 0), Math.max (p.y - w - a/2, 0));
	break;
      case 1:
	n.move (Math.max (p.x + w - a/2, 0), Math.max (p.y - a/2, 0));
	break;
      case 2:
	n.move (Math.max (p.x - a/2, 0), Math.max (p.y + w - a/2, 0));
	break;
      case 3:
      default:
	n.move (Math.max (p.x - w -a/2, 0), Math.max (p.y - a/2, 0));
	break;
    }
  }
  public void cleanUpHosts ()
  {
    for (int i = 0; i < numEdges; i++)
    {
      if (edges[i] != null)
      {
	Node n = edges[i].getOther (this);
        if (n instanceof Host)
	  cleanUpHost ((Host)n);
      }
    }
  }
  
  public Node [] getHosts ()
  {
    Node nodes[] = new Node [numEdges];
    
    for (int i = 0; i < numEdges; i++)
    {
      if (edges[i] != null)
      {
	Node n = edges[i].getOther (this);
        if (n instanceof Host)
	{
	  nodes [i] = n;
	}
	else nodes[i] = null;
      }
      else nodes[i] = null;
    }
    return nodes;
  }
    
  public Point getPoint (int n)
  {
    switch(getImageIndex())
    {
    case 0:
      return n<4?
	new Point (x + n*8 + 4, y + 4):
	  new Point (x + n*8 - 28, y + 25);
    case 1:
      return n<4?
	new Point (x + n*8 + 4, y + 25):
	  new Point (x + n*8 - 28, y + 4);
    case 2:
      return n<8?
	new Point (x + n*8 + 4, y + 4):
	  new Point (x + n*8 - 60, y + 25);
    case 3:
      return n<8?
	new Point (x + n*8 + 4, y + 25):
	  new Point (x + n*8 - 60, y + 4);
    default:
      return null;
    }
  }
  public boolean contains (int x, int y)
  {
    return super.contains (image, x, y);
  }
  public String getPrefix ()
  {
    return "s" + " " + numEdges;
  }
  public String toString ()
  {
    String s;

    s = getPrefix() + " " + super.toString ();
    if (flip > 0 )
      s += "flip "+flip+"\n";

    String lanString = getLanString ();

    if (lanString != null)
      s += "ports "+ lanString + "\n";

    return s;
  }
  public void paint (Graphics g)
  {
    super.paint (g);

    // Draw blue for Lan connectors

    for (int i = 0; i < numEdges; i++)
    {
      Rectangle r = getRectangle (i);
      
      if (hideHosts && edges [i] != null && edges [i].getOther (this) instanceof Host)
      {
	g.setColor (Color.red);
	g.fillRect (r.x, r.y, r.height, r.width);
      }
      
      else if (lan[i])
      {
	g.setColor (Color.cyan);
	g.fillRect (r.x, r.y, r.height, r.width);
      }      
    }
    
    // Draw glow point

    if (glowPoint != -1)
    {
      if (lan[glowPoint])
	g.setColor (Color.blue);
      else
	g.setColor (Color.red);
      Rectangle r = getRectangle (glowPoint);
      g.fillRect (r.x, r.y, r.height, r.width);
    }
  }
  
}

