/*
  Route.java
  Merlyn
  (c) 1997 Myricom, Inc.
  finucane@myri.com (David Finucane)
*/

import java.io.*;
import java.util.*;

class Route
{
  private Node to;
  private int length;
  private int hops[];

  Route (Node to, int length, int hops[])
  {
    this.to = to;
    this.length = length;
    this.hops = new int [length];
    for (int i = 0; i < length; i++)
      this.hops[i] = hops[i];
  }
  Route ()
  {
    length = 0;
  }
  Route (Node node)
  {
    to = node;
    length = 0;
  }
  Route (Route r, int hop)
  {
    this.hops = new int [r.length + 1];
    this.length = r.length + 1;
    for (int i = 0; i < r.length; i++)
      hops [i] = r.hops [i];
    hops[r.length] = hop;
  }
  public void setNode (Node node)
  {
    to = node;
  }
  public String toString ()
  {
    String s = "";
    if (length == 0)
      return "0";
    
    for (int i = 0; i < length; i++)
      s+= hops[i] + (i == length - 1 ? "" : " ");
    return s;
  }   
  public int getLength ()
  {
    return length;
  }
  public int[] getHops()
  {
    return hops;
  }
}








