/*
  Relaxer.java
  Merlyn
  (c) 1997 Myricom, Inc.
  finucane@myri.com (David Finucane)
*/

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import java.awt.image.*;

class Relaxer implements Runnable
{
  private boolean dead = false;
  private boolean relaxEdges;
  private long sleepTime = 300;
  private Tablet tablet;
  private ScrollPane scrollpane;
    
  public Relaxer (boolean relaxEdges, int sleepTime,
		  Tablet tablet, ScrollPane scrollpane)
  {
    this.relaxEdges = relaxEdges;
    this.sleepTime = sleepTime;
    this.tablet = tablet;
    this.scrollpane = scrollpane;
  }
  public void die ()
  {
    dead = true;
  }
  public void run ()
  {
    while (!dead)
    {
      try
	{
	  Thread.sleep (sleepTime);
	}
      catch (Exception e)
	{
	}
      tablet.relax (scrollpane.getSize(), relaxEdges);
	 
    }
  }
};

