/*
  OptionPanel.java
  Merlin
  (c) 1998 Myricom, Inc.
  dmazzoni@myri.com (Dominic Mazzoni)
*/

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

class OptionPanel extends Panel
{
  public Checkbox selfSendCheckbox;
  public Checkbox readRoutesCheckbox;
  public Checkbox randomSizeCheckbox;
  public Checkbox randomDelayCheckbox;
  public Checkbox histogramCheckbox;
  public Checkbox prioritySubnetCheckbox;
  public Checkbox sendAcksCheckbox;
  public Choice routingChoice;
  public Choice trafficChoice;
  public SuperSlider totalSlider;
  public SuperSlider sizeSlider;
  public SuperSlider delaySlider;
  public SuperSlider prioritySlider;
  public SuperSlider inSizeSlider;
  public SuperSlider outSizeSlider;
  
  
  private void addGb (Panel panel, GridBagLayout gb, GridBagConstraints c, Component o)
  {
    gb.setConstraints (o, c);
    panel.add (o);
  }

  public OptionPanel ()
  {
    setLayout (new BorderLayout ());
    Panel simulation = new Panel ();
    
    GridBagLayout gb = new GridBagLayout ();
    simulation.setLayout (gb);
    add ("West", simulation);    
    
    GridBagConstraints c = new GridBagConstraints();
    c.gridx = 0;
    c.gridwidth = GridBagConstraints.REMAINDER;
    c.anchor = GridBagConstraints.NORTHWEST;
    
    addGb (simulation, gb, c, routingChoice = new Choice());
    routingChoice.add("Shortest Path");
    routingChoice.add("Simple");
    routingChoice.add("Dijkstra (Node numbering)");
    routingChoice.add("Dijkstra (Node numbering from BFS root)");
    routingChoice.add("Dijkstra (Node numbering from bottom-up)");
    routingChoice.add("Dijkstra (Edge numbering)");
    routingChoice.add("Brute Force");
    routingChoice.select (1);

    addGb (simulation, gb, c, trafficChoice = new Choice());
    trafficChoice.add("Random Traffic");
    trafficChoice.add("Round-Robin");
    
    addGb (simulation, gb, c, selfSendCheckbox = new Checkbox("Hosts send messages to self"));
    addGb (simulation, gb, c, readRoutesCheckbox = new Checkbox("Automatically read routes"));
    addGb (simulation, gb, c, histogramCheckbox = new Checkbox("Generate histogram"));
    histogramCheckbox.setState (true);
    
    addGb (simulation, gb, c, randomSizeCheckbox = new Checkbox("Random Size"));
    addGb (simulation, gb, c, randomDelayCheckbox = new Checkbox("Random Delay"));
    addGb (simulation, gb, c, sendAcksCheckbox = new Checkbox ("Send Acks"));

    randomDelayCheckbox.setState (false);

    addGb (simulation, gb, c, totalSlider = new SuperSlider ("Messages: ", 1, 100000, 10000));
    addGb (simulation, gb, c, sizeSlider = new SuperSlider ("Packet Size: ", 1, 4000, 1000));
    addGb (simulation, gb, c, delaySlider = new SuperSlider ("Delay (micros): ", 0, 10, 0));
    addGb (simulation, gb, c, inSizeSlider = new SuperSlider ("In Buffer Size: ", 2, 10000, 10));
    addGb (simulation, gb, c, outSizeSlider = new SuperSlider ("Out Buffer Size: ", 2, 10000, 100));
    delaySlider.SetLogarithmic(true,10);

    addGb (simulation, gb, c, prioritySubnetCheckbox = new Checkbox("Use disjoint hi-priority subnet"));
    addGb (simulation, gb, c, prioritySlider = new SuperSlider ("% hi-priority", 0, 100, 0));

  }    
}
