/*
  Node.java
  Merlyn
  (c) 1997 Myricom, Inc.
  finucane@myri.com (David Finucane)
*/

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import java.awt.image.*;
import GraphicsUtil;


abstract class Node 
{
  private static final int MARK_SIZE = 5;
  public static final int NONE = 0;
  public static final int HOST = 1;
  public static final int SWITCH = 2;
  public static final int CLOUD = 3;
  protected int x, y;
  protected boolean dead;
  protected String name;
  protected String label = null;
  protected Edge edges [];
  protected Node match;
  protected double bandwidths[];
  protected boolean selected;
  protected Image image;
  protected Rectangle labelRect;
  protected int inPort;
  private static boolean showNames = false;
  private static boolean showGroups = false;
  static boolean hideHosts = false;
  protected int row;
  private boolean redSquare = false;
  private Route route;
  private int in;
  public int dx = 0;
  public int dy = 0;
  private Object group = null;
  private Vector extraNames;
  private Vector extraValues;
  public boolean neverSend = false;
  public boolean neverReceive = false;
  
  private class ImageLoader extends Component implements ImageObserver
  {
    public boolean imageUpdate (Image image, int flags, int x, int y, int width, int height)
    {
      return true;
    }
  }
  public Node (int x, int y, String name)
  {
    this.x = x;
    this.y = y;
    dead = false;
    this.name = name;
    this.label = new String(name);
    labelRect = null;
    extraNames = new Vector();
    extraValues = new Vector();
  }
  public void setDead(boolean dead)
  {
    this.dead = dead;
  }
  public boolean isDead()
  {
    return this.dead;
  }
  public void setInPort(int inPort)
  {
    this.inPort = inPort;
  }
  public int getInPort()
  {
    return inPort;
  }
  public String getName ()
  {
    return name;
  }
  public void addExtra(String name, String value)
  {
    if (name.equals("ports") && this instanceof Switch)
    {
      ((Switch)this).setLanFromString(value);
      return;
    }
    if (name.equals ("limit") && this instanceof Host)
    {
      if (value.equals ("neverSend"))
	neverSend = true;
      else if (value.equals ("neverReceive"))
	neverReceive = true;
      return;
    }
    if (name.equals("flip") && this instanceof Switch)
    {
      if (value.indexOf('1')!=-1)
	((Switch)this).flip();
      return;
    }
    if (name.equals("label"))
    {
      label = new String(value);
      return;
    }
    if (name.equals("x"))
    {
      try {
	x = Integer.parseInt(value);
      }
      catch (Exception e){
      }
      return;
    }
    if (name.equals("y"))
    {
      try {
	y = Integer.parseInt(value);
      }
      catch (Exception e){
      }
      return;
    }
    extraNames.addElement(name);
    extraValues.addElement(value);
  }
  public void setGroup (Object group)
  {
    this.group = group;
  }
  public Object getGroup ()
  {
    return group;
  }
  public int getNameNumber ()
  {
    try
      {
	return Integer.valueOf (name.substring(1)).intValue();
      }
    catch (Exception e)
      {
	return -1;
      }
  }
  public void connect (Edge e, int n)
  {
    edges[n] = e;
  }
  public static void setShowNames (boolean showNames)
  {
    Node.showNames = showNames;
  }
  public static void setShowGroups (boolean showGroups)
  {
    Node.showGroups = showGroups;
  }
  public static boolean showLabels()
  {
    return showNames || showGroups;
  }
  public void setRedSquare (boolean b)
  {
    redSquare = b;
  }
  public void setBandwidth (int n, double d)
  {
    bandwidths[n] = d;
  }
  public void setMatch (Node n)
  {
    match = n;
    if (n != null)
      n.match = this;
  }
  public Node getMatch ()
  {
    return match;
  }
  public void setRow (int row)
  {
    this.row = row;
  }
  public int getRow ()
  {
    return row;
  }
  public void setSelected (boolean selected)
  {
    this.selected = selected;
  }
  public boolean getSelected ()
  {
    return selected;
  }
  public double getBandwidth (int n)
  {
    return bandwidths[n];
  }
  public double getBandwidth (Edge e)
  {
    return getBandwidth (getPosition (e));
  }
  public int getX()
  {
    return x;
  }
  public int getY()
  {
    return y;
  }
  public void setText (String text) // sets the label
  {
    this.label = text;
  }
  public String getText ()
  {
    return label;
  }
  public void finish()
  {
    for (int i = 0; i < edges.length; i++)
      if (edges[i] != null)
	edges[i].move (this, getPoint (i));
  }
  public void move (int x, int y)
  {
    this.x = x;
    this.y = y;

    this.finish();
  }
  
  public void moveGroup (int x, int y)
  {
    int dx = x - this.x;
    int dy = y - this.y;
    
    this.x = x;
    this.y = y;
    
    for (int i = 0; i < edges.length; i++)
    {
      if (edges[i] != null)
      {
	edges[i].move (this, getPoint (i));
        Node n = edges[i].getOther (this);
	if (n instanceof Host)
	{
	  int nx = n.x + dx;
	  int ny = n.y + dy;
	  if (nx < 0) nx = 0;
	  if (ny < 0) ny = 0;
	  
	  n.move (nx, ny);
	}
	
      }      
    }
  }

  public int getSwitchCount ()
  {
    int c = 0;
    for (int i = 0; i < edges.length; i++)
    {
      if (edges[i] != null)
      {
	Node n = edges[i].getOther (this);
        if (n instanceof Switch)
	  c++;
      }      
    }
    return c;
  }
  public int getCloudCount ()
  {
    int c = 0;
    for (int i = 0; i < edges.length; i++)
    {
      if (edges[i] != null)
      {
	Node n = edges[i].getOther (this);
        if (n instanceof Cloud)
	  c++;
      }      
    }
    return c;
  }
  public int getHostCount ()
  {
    int c = 0;
    for (int i = 0; i < edges.length; i++)
    {
      if (edges[i] != null)
      {
	Node n = edges[i].getOther (this);
        if (n instanceof Host)
	  c++;
      }      
    }
    return c;
  }
  public Node [] getHosts ()
  {
    int c = getHostCount ();
    if (c == 0)
      return null;

    Node hosts[] = new Node [c];
    
    for (int i = 0; i < edges.length; i++)
    {
      if (edges[i] != null)
      {
	Node n = edges[i].getOther (this);
        if (n instanceof Host)
	{
	  hosts [c - 1] = n;
	  c--;
	}
      }      
    }
    return hosts;
  }
  public Node [] getSwitches ()
  {
    int c = getSwitchCount ();
    if (c == 0)
      return null;

    Node switches[] = new Node [c];
    
    for (int i = 0; i < edges.length; i++)
    {
      if (edges[i] != null)
      {
	Node n = edges[i].getOther (this);
        if (n instanceof Switch)
	{
	  switches [c - 1] = n;
	  c--;
	}
      }      
    }
    return switches;
  }

  public Node [] getSwitchesAndClouds ()
  {
    int c = getSwitchCount () + getCloudCount ();
    if (c == 0)
      return null;

    Node switches[] = new Node [c];
    
    for (int i = 0; i < edges.length; i++)
    {
      if (edges[i] != null)
      {
	Node n = edges[i].getOther (this);
        if (n instanceof Switch || n instanceof Cloud)
	{
	  switches [c - 1] = n;
	  c--;
	}
      }      
    }
    return switches;
  }

  public Node getNode(int portNum)
  {
    if (portNum<0 || portNum>=edges.length || edges[portNum]==null)
      return null;
    else
      return edges[portNum].getOther (this);
  }
  
  public Node [] getNodes ()
  {
    int c = 0;
    Node nodes[] = new Node [edges.length];
    
    for (int i = 0; i < edges.length; i++)
      if (edges[i] != null)
	nodes [c++] = edges[i].getOther (this);

    Node answer [] = new Node [c];
    for (int i = 0; i < c; i++)
      answer [i] = nodes [i];
    return answer;
  }
  public Node [] getMatchedNodes ()
  {
    return getNodes (true);
  }
  public Node [] getUnmatchedNodes ()
  {
    return getNodes (false);
  }
  private Node [] getNodes (boolean match)
  {
    int c = 0;
    Node nodes[] = new Node [edges.length];
    
    for (int i = 0; i < edges.length; i++)
    {
      if (edges[i] != null)
      {
	Node n = edges[i].getOther (this);
	if ((match && n.getMatch () != null) ||
	     (!match && n.getMatch () == null))
	  nodes [c++] = n;
      }
    }
    Node answer[] = new Node [c];
    for (int i = 0; i < c; i++)
      answer [i] = nodes [i];
    return answer;
  }
  public Edge getEdge (int n)
  {
    return edges [n];
  }
  public Edge[] getEdges ()
  {
    return edges;
  }
  public int getPort (Edge e)
  {
    for (int i = 0; i < edges.length; i++)
      if (edges[i] == e)
	return i;
    return -1;
  }
  public String PortsToString ()
  {
    String s = "";
    return s;
  }
  public String toString ()
  {
    String s = "\"" + name + "\"\n";
    
    int ne = 0;
    for (int i = 0; i < edges.length; i++)
      if (edges[i] != null)
	ne ++;
    
    s += ne + "\n";
    for (int i = 0; i < edges.length; i++)
      if (edges[i] != null)
	{
	  Node m = edges[i].getOther (this);
	  s += i + " " + m.getPrefix() +
	    " \"" + m.name + "\" " + m.getPort (edges[i]) + "\n";
	}

    s += "x " + x + "\n";
    s += "y " + y + "\n";
    s += "label \"" + label + "\"\n";

    if (neverSend)
      s += "limit neverSend\n";
    if (neverReceive)
      s += "limit neverReceive\n";
    
    // Extra name/value pairs

    for(int i=0; i<extraNames.size(); i++)
      s += "\"" + extraNames.elementAt(i) + "\" \"" +
	extraValues.elementAt(i) + "\"\n";

    return s;
  }
  public abstract String getPrefix ();
  public abstract boolean contains (int x, int y);
  protected boolean contains (Image image, int x, int y)
  {
    Rectangle r = new Rectangle (this.x, this.y, image.getWidth(null), image.getHeight(null));
    return r.contains (x, y);
  }
  public Dimension getSize ()
  {
    return new Dimension (image.getWidth (null), image.getHeight (null));
  }
  public boolean intersects (Rectangle r)
  {
    Rectangle b = new Rectangle (x, y, image.getWidth (null), image.getHeight (null));
    return b.intersects (r);
  }
  public Route getRoute ()
  {
    return route;
  }
  public void setRoute (Route route)
  {
    this.route = route;
  }
  public Point getPoint (Edge e)
  {
    return getPoint (getPosition (e));
  }
  public abstract Point getPoint (int n);
  public abstract int getPosition (Edge e);
  public abstract int getNumEdges ();
  public Rectangle getLabelRect()
  {
    return labelRect;
  }
  public boolean labelContains(int x, int y)
  {
    if (labelRect != null)
      return labelRect.contains(x, y);
    else
      return false;
  }
  public void paintLabel (Graphics g)
  {
    if (showNames || (showGroups && group != null))
    {
      String labelString = (showGroups && group != null) ?
	                 group.toString() :
	                 (label != null ? label : "");
      int imageWidth = image.getWidth (null);
      int imageHeight = image.getHeight (null);

      FontMetrics fm = g.getFontMetrics();
      int descent = fm.getDescent();
      labelRect = new Rectangle();
      labelRect.width = fm.stringWidth (labelString) + descent + 2;
      labelRect.height = fm.getMaxAscent() + descent + 1;
      labelRect.x = x + imageWidth / 2 - labelRect.width / 2 - 2;
      labelRect.y = y + imageHeight;

      g.setColor (Color.white);
      g.fillRect (labelRect.x, labelRect.y,
		  labelRect.width, labelRect.height);
      g.setColor (Color.black);
      g.drawString (labelString,
		    labelRect.x + descent,
		    labelRect.y + labelRect.height - descent);
      g.drawRect (labelRect.x, labelRect.y,
		  labelRect.width, labelRect.height);

    }
  }
  public void paint (Graphics g)
  {
    g.drawImage (image, x, y, null);
    int imageWidth = image.getWidth (null);
    int imageHeight = image.getHeight (null);
    
    if (selected || redSquare)
    {
      g.setColor (redSquare ? Color.red : Color.black);
      g.fillRect (x - (MARK_SIZE + 1), y - (MARK_SIZE + 1),
		  MARK_SIZE, MARK_SIZE);
      g.fillRect (x + imageWidth + 1, y - (MARK_SIZE + 1),
		  MARK_SIZE, MARK_SIZE);
      g.fillRect (x - (MARK_SIZE + 1), y + imageHeight + 1,
		  MARK_SIZE, MARK_SIZE);
      g.fillRect (x + imageWidth + 1, y + imageHeight + 1,
		  MARK_SIZE, MARK_SIZE);
    }

    if (dead)
    {
      // red X

      g.setColor (Color.red);
      g.drawLine(x,y,x+imageWidth-1,y+imageHeight);
      g.drawLine(x+imageWidth-1,y,x,y+imageHeight);
      g.drawLine(x+1,y,x+imageWidth,y+imageHeight);
      g.drawLine(x+imageWidth,y,x+1,y+imageHeight);
    }
  }
  public void disconnect (Edge e)
  {
    int p = getPosition (e);

    if (p != -1)
      edges[p] = null;
  }
  public void setIn (int in)
  {
    this.in = in;
  }
  public Image loadImage (String name)
  {
    try
    {
      Toolkit toolkit = Toolkit.getDefaultToolkit();
      Image image = toolkit.getImage(getClass().getResource (name));
      MediaTracker tracker = new MediaTracker (new ImageLoader ());
      tracker.addImage (image, 0);
      tracker.waitForID (0);
      return image;
    }
    catch (Exception e)
    {
      System.out.println (e);
    }
    return null;
  }
  public int getIn ()
  {
    return in;
  }
  
}
