/*
  Edge.java
  Merlyn
  (c) 1997 Myricom, Inc.
  finucane@myri.com (David Finucane)
*/

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import java.awt.image.*;
import GraphicsUtil;


class Edge
{
  private static final double ellipseFactor = 1.5;
  private static final int pointSize = 4;
  public static final int NUM_POINTS = 3;
  private static boolean showColors = false;
  private static boolean showNumbers = false;
  private static boolean allTest = false;
  private Point points[] = new Point [NUM_POINTS];
  private Color pointColor = Color.black;
  private String label;
  private Rectangle labelBounds;
  private boolean selected = false;
  private int selectedPoint = -1;
  private Node n1, n2;
  private int badRoutes[];
  private int goodRoutes[];
  private static double highestErrorFigure = 1;
  private int routeCount = 0;
  private boolean glow = false;
  private boolean dead = false;
  
  private static final Color colors[] =
  {
    Color.black,
    Color.blue,
    Color.cyan,
    Color.green,
    Color.magenta,
    Color.orange,
    Color.pink,
    Color.red
  };

  public Edge (int x, int y)
  {
    for (int i = 0; i < NUM_POINTS; i++)
      this.points[i] = new Point (0,0);

    points[0].x = points[NUM_POINTS - 1].x = x;
    points[0].y = points[NUM_POINTS - 1].y = y;
    straighten ();
    badRoutes = new int [2];
    goodRoutes = new int [2];
  }
  public void setDead(boolean dead)
  {
    this.dead = dead;
  }
  public int getRouteCount ()
  {
    return routeCount;
  }
  public void setRouteCount (int c)
  {
    routeCount = c;
  }
  public Edge (Node n1, Node n2, Point points[])
  {
    for (int i = 0; i < NUM_POINTS; i++)
      this.points[i] = new Point (0,0);

    this.n1 = n1;
    this.n2 = n2;
    
    for (int i = 0; i < NUM_POINTS; i++)
    {
      this.points[i].x = points[i].x;
      this.points[i].y = points[i].y;
    }
    
    badRoutes = new int [2];
    goodRoutes = new int [2];
  }
  private Node getLeft ()
  {
    if (n1.getX() < n2.getX())
      return n1;
    else if (n1.getX() > n2.getX())
      return n2;
    else if (n1.getY() < n2.getY())
      return n1;
    else return n2;
  }
  public Edge (Node n1, Node n2, int p1, int p2)
  {
    for (int i = 0; i < NUM_POINTS; i++)
      this.points[i] = new Point (0,0);

    this.n1 = n1;
    this.n2 = n2;

    points[0] = n1.getPoint (p1);
    points[NUM_POINTS - 1] = n2.getPoint (p2);
    
    straighten ();
    
    badRoutes = new int [2];
    goodRoutes = new int [2];
  }
  public static void setAllTest (boolean b)
  {
    allTest = b;
  }
  
  public boolean connectedTo (Node n)
  {
    return n == n1 || n == n2;
  }
  public Node getOther (Node n)
  {
    return n == n1 ? n2 : n1;
  }
  public Node getNode ()
  {
    return n1;
  }
  public void setOther (Node n1, Node n2)
  {
    if (this.n1 == n1)
      this.n2 = n2;
    else
      this.n1 = n2;
  }
  public void move (Node n, Point p)
  {
    int i = n == n1 ? 0 : NUM_POINTS - 1;
    points[i].x = p.x;
    points[i].y = p.y;
    straighten ();
  }
  public void move (int x, int y)
  {
    points[NUM_POINTS - 1].x = x;
    points[NUM_POINTS - 1].y = y;
    straighten ();
  }
  private double getDistance (Point a, Point b, int x, int y)
  {
    // Dom's method: find intersection of perpendicular lines

    double m, ix, iy, d;

    if (b.x == a.x) // treat vertical lines separately to avoid 0 div
      {
	if ((y-a.y)*(b.y-y)>=0)
	  d = 0.1*Math.abs(a.x-x); // distance to vertical line
	else
	  d = 1000; // outside of the vertical line
	return d;
      }

    m = ((double)(b.y-a.y))/((double)(b.x-a.x));

    ix = (y + x/m - a.y + m*a.x)/(m+1/m);

    if ((ix-a.x)*(b.x-ix)>=0)
      {
	// Get dist to line
	iy = y + (ix-x)/m;
	d = 0.1*Math.sqrt(Math.pow(ix-x,2) + Math.pow(iy-y,2));

	return d;
      }
    else
      {
	// Outside of line
	return 1000;
      }

    /*

    // David's method: ellipse stuff

    double dp = Math.sqrt (Math.pow ((a.x - b.x), 2) + Math.pow ((a.y - b.y), 2));
    double da = Math.sqrt (Math.pow ((a.x - x), 2) + Math.pow ((a.y - y), 2));
    double db = Math.sqrt (Math.pow ((b.x - x), 2) + Math.pow ((b.y - y), 2));
    
    double d = Math.sqrt (Math.pow (da, 2) + Math.pow (db, 2));
    
    return d / (dp * ellipseFactor);
    */
  }
  public double getDistance (int x, int y)
  {
    double low = 1000;
    for (int i = 0; i <= NUM_POINTS - 2; i++)
    {
      double d = getDistance (points[i], points[i + 1], x, y);
      if (d < low)
	low = d;
    }
    return low;
  }
  public void straighten ()
  {
    Point p1 = points[0];
    Point p2 = points[NUM_POINTS - 1];
    
    int dx = Math.abs (p1.x - p2.x);
    int dy = Math.abs (p1.y - p2.y);
    int xs = p1.x < p2.x ? 1 : -1;
    int ys = p1.y < p2.y ? 1 : -1;
    
    for (int i = 1; i < NUM_POINTS - 1; i++)
    {
      points[i].x = points[0].x + xs * i * dx / (NUM_POINTS - 1);
      points[i].y = points[0].y + ys * i * dy / (NUM_POINTS - 1);
    }
  }
  public void setSelected (boolean selected)
  {
    this.selected = selected;
  }
  public boolean mouseDown (int x, int y)
  {
    int i;
    int sp = -1;
    
    for (i = 0; i < NUM_POINTS - 1; i++)
    {
      Rectangle pr = new Rectangle (points[i].x - pointSize / 2,
				    points[i].y - pointSize / 2,
				    pointSize, pointSize);
      
      if (pr.contains (x, y))
      {
	sp = i;
	break;
      }
      
      int x1 = Math.min (points[i].x, points[i+1].x);
      int x2 = Math.max (points[i].x, points[i+1].x);
      int y1 = Math.min (points[i].y, points[i+1].y);
      int y2 = Math.max (points[i].y, points[i+1].y);

      Rectangle r = new Rectangle (x1, y1, x2, y2);
      
      if (r.contains (x, y))
	break;
    }
    
    selected = (i < NUM_POINTS);

    if (selected)
      selectedPoint = sp;

    return selected;
  }
  public boolean mouseUp (int x, int y)
  {
    return true;
  }
  public boolean mouseDrag (int x, int y)
  {
    if (selectedPoint == -1)
      return false;

    points[selectedPoint].x = x;
    points[selectedPoint].y = y;
    return true;
  }
  public static void setColors (boolean b)
  {
    showColors = b;
  }
  public static void setNumbers (boolean b)
  {
    showNumbers = b;
  }
  public double getErrorFigure ()
  {
    return badRoutes[0] > badRoutes[1] ? badRoutes[0] : badRoutes[1];
  }
  public static void setHighestErrorFigure (double d)
  {
    highestErrorFigure = d;
  }
  public void setGlow (boolean glow)
  {
    this.glow = glow;
  }
  public void paint (Graphics g)
  {
    int t1  = 1;
    Color c1 = Color.black;
    int t2 = t1;
    Color c2 = c1;

    if (allTest && n1 != null && n2 != null)
    {
      g.setColor (pointColor);

      if (badRoutes[0] != 0 || badRoutes[1] != 0)
      {
	String s;
	if (getLeft() == n1)
	  s = badRoutes[0] + "/" + badRoutes[1];
	else
	  s = badRoutes[1] + "/" + badRoutes[0];
	
	FontMetrics fm = g.getFontMetrics();
        int w = fm.stringWidth (s);
        Point ap = points[0];
        Point bp = points[NUM_POINTS - 1];
        int x = ap.x + (bp.x-ap.x)/2 - w/2;
        int y = ap.y + (bp.y-ap.y)/2;
        int descent = fm.getDescent();
        int step = descent + fm.getMaxAscent();
        g.drawString (s, x, y + step - descent);
      }
    }
    
    if (!allTest && showColors && n1 != null && n2 != null)
    {
      double d = n1.getBandwidth (this) * colors.length;
      t1 = (int)d + 1;
      c1 = colors[(int)(d >= colors.length ? colors.length - 1: d)];

      d = n2.getBandwidth (this) * colors.length;
      t2 = (int)d + 1;
      c2 = colors[(int)(d >= colors.length ? colors.length - 1: d)];

      double br1 = n1.getBandwidth(this)*2.0;
      if (br1>1.0)
	br1 = 1.0;
      c1 = new Color(Color.HSBtoRGB((float)br1,(float)1.0,(float)br1));
      double br2 = n2.getBandwidth(this)*2.0;
      if (br2>1.0)
	br2 = 1.0;
      c2 = new Color(Color.HSBtoRGB((float)br2,(float)1.0,(float)br2));
    }

    if (allTest && highestErrorFigure != 0 && showColors && n1 != null && n2 != null)
    {
      double d = badRoutes[0]/ highestErrorFigure * colors.length;
      
      t1 = (int)d + 1;
      c1 = colors[(int)(d >= colors.length ? colors.length - 1: d)];

      d = badRoutes[1]/ highestErrorFigure * colors.length;
      t2 = (int)d + 1;
      c2 = colors[(int)(d >= colors.length ? colors.length - 1: d)];
    }

    if (routeCount > 0 || glow || dead)
    {
      c1 = c2 = glow || dead? Color.red : Color.blue;
      t1 = t2 = 3;
    }    
    for (int i = 0; i < NUM_POINTS - 1; i++)
      GraphicsUtil.drawLine (g, points[i].x, points[i].y,
			     points[i+1].x, points[i+1].y,
			     i < NUM_POINTS/2 ? t1 : t2,
			     i < NUM_POINTS/2 ? c1 : c2);

    if (selected)
    {
      g.setColor (pointColor);
      for (int i = 1; i < NUM_POINTS - 1; i++)
        g.fillRect (points[i].x - pointSize / 2, points[i].y - pointSize / 2,
                    pointSize, pointSize);
    }

    if (showNumbers && n1!= null && n2 != null)
    {
      g.setColor (pointColor);
      double d1 = getLeft().getBandwidth(this);
      double d2 = getOther (getLeft()).getBandwidth(this);

      //if (d1 != 0 && d2 != 0)
      // - DMM

      if (d1 != 0 || d2 != 0)
      {
        String s =
          (d1 == 0 ? "" : "" + d1) + "/" +
          (d2 == 0 ? "" : "" + d2);
          FontMetrics fm = g.getFontMetrics();
        int w = fm.stringWidth (s);
        Point ap = points[0];
        Point bp = points[NUM_POINTS - 1];
        int x = ap.x + (bp.x-ap.x)/2 - w/2;
        int y = ap.y + (bp.y-ap.y)/2;
        int descent = fm.getDescent();
        int step = descent + fm.getMaxAscent();
        g.drawString (s, x, y + step - descent);
      }
    }
  }
  public void clearError ()
  {
    goodRoutes[0] = goodRoutes[1] = badRoutes[0] = badRoutes[1] = 0;
  }
  public void addError (Node n, int error)
  {
    int i = n == n1 ? 0 : 1;
    
    if (error == 0)
      goodRoutes[i]++;
    else
      badRoutes[i]+=error;
  }
}





