/*
  AppFont.java

*/

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

class AppFont
{
  static Font getFont (String name)
  {    
    int minWidth = 55;

    if (System.getProperty ("user.name").equals ("cohen"))
      return new Font (name, Font.PLAIN, 14);

    if (name.equals ("Dialog"))
      minWidth = 45;
    else if (name.equals ("TimesRoman"))
      minWidth = 50;
    
    for (int i = 8; i < 15; i++)
    { 
      Font f = new Font (name, Font.PLAIN, i);
      FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(f);
      int width = fm.stringWidth ("test string");
      //System.out.println (i + " " + width);
      if (width >= minWidth)
	return f;
    }
    System.out.println ("couldn't guess decent font");
    return new Font (name, Font.PLAIN, 11);
  }
}
