

/*

// n x n grid of switches, each with 8 hosts
//
// modified torus connections

main()
{
  int x,y,i;
  int xx,yy;
  int ss;
  int xDim = 4;
  int yDim = 4;
  const int rack = 8; // hosts per switch
  int xtab[13] = {0,1,2,3,4,5,6,7,8,9,10,11,12};  //{0,2,1,3,6,4,7,5};
  int ytab[13] = {0,1,2,3,4,5,6,7,8,9,10,11,12};  //{0,2,4,5,3,1,6,7};
  int ho; // host offset

  scanf("%d",&xDim);
  yDim = xDim;

  numSwitches = xDim * yDim;
  numHosts = xDim * yDim * rack;

  numDeadSwitches = 0;
  numDeadHosts = 0;

  numNodes = numSwitches + numHosts;
  node = (struct Node *)malloc(numNodes*sizeof(struct Node));
  for(i=0; i<numNodes; i++)
    Init(&node[i], i);

  ho = xDim*yDim;

  for(x=0; x<xDim; x++)
    for(y=0; y<yDim; y++)
    {
      ss = y*xDim+x;
      if (node[ss].type != -1)
      {
	node[ss].number = y*xDim+x;
	node[ss].x = 90*xtab[x] + 45 - 2*ytab[y];
	node[ss].y = 100*ytab[y] + 80 + 10*xtab[x];
	node[ss].ports = 16;
	
	sprintf(node[ss].name,
		"s-%d-%d",x,y);

	node[ss].gx = x;
	node[ss].gy = y;

	for(i=0; i<rack; i++)
	{
	  node[ho+(ss)*rack+i].type = 1; // host
	  node[ho+(ss)*rack+i].x = 90*xtab[x] + 8*i + 30 - 2*ytab[y];
	  node[ho+(ss)*rack+i].y = 100*ytab[y] + 20 + 10*xtab[x];
	  
	  sprintf(node[ho+(ss)*rack+i].name,
		  "h-%d-%d-%c",x,y,'a'+i);
	  
	  ConnectPorts(ho+(ss)*rack+i,0,ss,i);
	}
      }
    }

  for(y=0; y<yDim; y++)
    for(x=0; x<xDim; x++)
    {
      ConnectNodes(y*xDim+x,y*xDim+((x+1)%xDim));
      ConnectNodes(y*xDim+x,y*xDim+((x+2)%xDim));
    }
  
  for(x=0; x<xDim; x++)
    for(y=0; y<yDim; y++)
    {
      ConnectNodes(y*xDim+x,((y+1)%yDim)*xDim+x);
      ConnectNodes(y*xDim+x,((y+2)%yDim)*xDim+x);
    }

  Output();
}

*/

/*

// 128 nodes, using 24 16-port switches

main()
{
  int i,j,k,l;

  numHosts = 128;
  numSwitches = 24;
  numNodes = numHosts + numSwitches;
  node = (struct Node *)malloc(numNodes*sizeof(struct Node));

  for(i=0; i<numNodes; i++)
    Init(&node[i], i);

  // Place hosts and connect hosts to switches
  for(i=0; i<64; i++)
      {
	node[numSwitches+i].x = i*10+10;
	node[numSwitches+i].y = 40;
	node[numSwitches+i].type = 1; // host

	ConnectNodes(numSwitches+i,i/8);

	node[numSwitches+i+64].x = i*10+10;
	node[numSwitches+i+64].y = 360;
	node[numSwitches+i+64].type = 1; // host
	
	ConnectNodes(numSwitches+i+64,i/8+16);
      }
  // Place 16-port switches
  for(i=0; i<8; i++)
  {
    node[i].x = i*80+40;
    node[i].y = 100;
    node[i].ports = 16;
    node[i+8].x = i*80+40;
    node[i+8].y = 200;
    node[i+8].ports = 16;
    node[i+16].x = i*80+40;
    node[i+16].y = 300;
    node[i+16].ports = 16;
  }
  for(i=0; i<8; i++)
  {
    for(j=8; j<16; j++)
      ConnectNodes(i,j);
  }
  for(i=0; i<8; i++)
  {
    for(j=8; j<16; j++)
      ConnectNodes(i+16,j);
  }
  Output();
}

*/

/*

// 4 x 3 grid of switches, each with 8 hosts
//
// modified torus connections

main()
{
  int x,y,i;
  int xx,yy;
  int ss;
  const int xDim = 4;
  const int yDim = 3;
  const int rack = 8; // hosts per switch
  int xtab[8] = {0,1,2,3,4,5,6,7};  //{0,2,1,3,6,4,7,5};
  int ytab[8] = {0,1,2,3,4,5,6,7};  //{0,2,4,5,3,1,6,7};
  int ho; // host offset

  numSwitches = xDim * yDim;
  numHosts = xDim * yDim * rack;

  numDeadSwitches = 3;
  numDeadHosts = 3*rack;

  numNodes = numSwitches + numHosts;
  node = (struct Node *)malloc(numNodes*sizeof(struct Node));
  for(i=0; i<numNodes; i++)
    Init(&node[i], i);

  ho = xDim*yDim;

  // kill 3 of 4 in bottom row
  for(x=1; x<xDim; x++)
    for(y=2; y<3; y++)
    {
      ss = ytab[y]*xDim+xtab[x];
      node[ss].type = -1;
      for(i=0; i<rack; i++)
	node[ho+(ss)*rack+i].type = -1;
    }

  for(x=0; x<xDim; x++)
    for(y=0; y<yDim; y++)
    {
      ss = ytab[y]*xDim+xtab[x];
      if (node[ss].type != -1)
      {
	node[ss].number = x*yDim+y + (x>0? 2: 0);
	node[ss].x = 90*xtab[x] + 45 - 2*ytab[y];
	node[ss].y = 100*ytab[y] + 80 + 10*xtab[x];
	node[ss].ports = 16;
	
	sprintf(node[ss].name,
		"s-%d-%d",xtab[x],ytab[y]);

	node[ss].gx = xtab[x];
	node[ss].gy = ytab[y];

	for(i=0; i<rack; i++)
	{
	  node[ho+(ss)*rack+i].type = 1; // host
	  node[ho+(ss)*rack+i].x = 90*xtab[x] + 8*i + 30 - 2*ytab[y];
	  node[ho+(ss)*rack+i].y = 100*ytab[y] + 20 + 10*xtab[x];
	  
	  sprintf(node[ho+(ss)*rack+i].name,
		  "h-%d-%d-%c",xtab[x],ytab[y],'a'+i);
	  
	  ConnectPorts(ho+(ss)*rack+i,0,ss,i);
	}
      }
    }

  for(y=0; y<yDim; y++)
    for(x=0; x<xDim; x+=2)
      for(i=1; i<xDim; i+=2)
	ConnectNodesMinPN(ytab[y]*xDim+xtab[x],ytab[y]*xDim+xtab[i],8);
  
  for(x=0; x<xDim; x++)
    for(y=0; y<yDim; y+=2)
      for(i=1; i<yDim; i+=2)
	ConnectNodesMinPN(ytab[y]*xDim+xtab[x],ytab[i]*xDim+xtab[x],12);

  Output();
}

*/

/*

400 nodes in a 10 x 5 grid, simple connections

main()
{
  int x,y,i;
  const int xDim = 10;
  const int yDim = 5;
  int ho; // host offset

  numSwitches = xDim * yDim;
  numHosts = xDim * yDim * 8;

  numNodes = numSwitches + numHosts;
  node = (struct Node *)malloc(numNodes*sizeof(struct Node));
  for(i=0; i<numNodes; i++)
    Init(&node[i], i);

  ho = xDim*yDim;

  for(x=0; x<xDim; x++)
    for(y=0; y<yDim; y++)
    {
      for(i=0; i<8; i++)
      {
	node[ho+(y*xDim+x)*8+i].type = 1; // host
	node[ho+(y*xDim+x)*8+i].x = 90*x + 8*i + 30 - 2*y;
	node[ho+(y*xDim+x)*8+i].y = 100*y + 20 + 10*x;

	sprintf(node[ho+(y*xDim+x)*8+i].name,
		"h (%d,%d)-%c",x,y,'a'+i);

	ConnectPorts(ho+(y*xDim+x)*8+i,0,y*xDim+x,i);
      }

      node[y*xDim+x].x = 90*x + 45 - 2*y;
      node[y*xDim+x].y = 100*y + 80 + 10*x;
      node[y*xDim+x].ports = 16;

      sprintf(node[y*xDim+x].name,
	      "s (%d,%d)",x,y);

      if (x>0)
      {
	ConnectPorts(y*xDim+x,8,y*xDim+(x-1),12);
	ConnectPorts(y*xDim+x,9,y*xDim+(x-1),13);
      }
      if (y>0)
      {
	ConnectPorts(y*xDim+x,14,(y-1)*xDim+x,10);
	ConnectPorts(y*xDim+x,15,(y-1)*xDim+x,11);
      }
    }

  Output();
}

*/

/*

160 hosts

main()
{
  int i,j,k,l;

  numNodes = 160 + 32 + 6;
  node = (struct Node *)malloc(numNodes*sizeof(struct Node));

  for(i=0; i<numNodes; i++)
    Init(&node[i], i);

  // Place hosts and connect hosts to sw8's
  for(i=0; i<40; i++)
      {
	node[i+32].x = 10+i*8;
	node[i+32].y = 320-i*8;
	node[i+32].type = 1; // host

	ConnectNodes(i+32,(i/5));

	node[i+72].x = 540+i*8;
	node[i+72].y = 10+i*8;
	node[i+72].type = 1; // host

	ConnectNodes(i+72,(i/5)+8);

	node[i+112].x = 10+i*8;
	node[i+112].y = 540+i*8;
	node[i+112].type = 1; // host

	ConnectNodes(i+112,(i/5)+16);

	node[i+152].x = 500+i*8;
	node[i+152].y = 860-i*8;
	node[i+152].type = 1; // host

	ConnectNodes(i+152,(i/5)+24);
      }
  // Place sw8's
  for(i=0; i<8; i++)
      {
	node[i].x = 40+i*40;
	node[i].y = 340-i*40;

	node[i+8].x = 520+i*40;
	node[i+8].y = 40+i*40;

	node[i+16].x = 40+i*40;
	node[i+16].y = 500+i*40;

	node[i+24].x = 420+i*40;
	node[i+24].y = 800-i*40;
    }


  // Place sw16's
  node[192].ports = 16;
  node[192].x = 400;
  node[192].y = 300;
  node[193].ports = 16;
  node[193].x = 200;
  node[193].y = 400;
  node[194].ports = 16;
  node[194].x = 600;
  node[194].y = 400;
  node[195].ports = 16;
  node[195].x = 400;
  node[195].y = 500;
  node[196].ports = 16;
  node[196].x = 360;
  node[196].y = 400;
  node[197].ports = 16;
  node[197].x = 440;
  node[197].y = 400;

  // connect

  for(i=0; i<8; i++)
  {
    ConnectNodes(i+8,192);
    ConnectNodes(i+8,194);
    ConnectNodes(i+8,196);
  }
  for(i=0; i<8; i++)
  {
    ConnectNodes(i,192);
    ConnectNodes(i,193);
    ConnectNodes(i,197);
  }
  for(i=0; i<8; i++)
  {
    ConnectNodes(i+16,193);
    ConnectNodes(i+16,195);
    ConnectNodes(i+16,196);
  }
  for(i=0; i<8; i++)
  {
    ConnectNodes(i+24,194);
    ConnectNodes(i+24,195);
    ConnectNodes(i+24,197);
  }

  Output();
}

*/

/*

// N = 128, BBW = 64, D = 5

main()
{
  int i,j,k,l;

  numNodes = 208;
  node = (struct Node *)malloc(numNodes*sizeof(struct Node));

  for(i=0; i<numNodes; i++)
    Init(&node[i], i);

  OctSwitch(64);
  OctSwitch(72);
  OctSwitch(80);
  OctSwitch(88);

  OctSwitch(112);
  OctSwitch(120);
  OctSwitch(128);
  OctSwitch(136);

  // Place hosts and connect hosts to oct-switches
  for(j=0; j<4; j++)
    for(i=0; i<16; i++)
      {
	node[i+16*j].x = (i+j*16)*20+20;
	node[i+16*j].y = 40;
	node[i+16*j].type = 1; // host
	
	node[i+16*j+144].x = (i+j*16)*20+20;
	node[i+16*j+144].y = 480;
	node[i+16*j+144].type = 1; // host
	
	ConnectNodes(i+16*j,(i/4)+8*j+64);
	ConnectNodes(i+16*j+144,(i/4)+8*j+116);
      }
  // Place oct-switches
  for(j=0; j<4; j++)
    for(i=0; i<4; i++)
      {
	node[i+64+8*j].x = (i+4*j)*80+40;
	node[i+64+8*j].y = 100;
	node[i+68+8*j].x = (i+4*j)*80+40;
	node[i+68+8*j].y = 160;

	node[i+112+8*j].x = (i+4*j)*80+40;
	node[i+112+8*j].y = 360;
	node[i+116+8*j].x = (i+4*j)*80+40;
	node[i+116+8*j].y = 420;
    }

  // Place duals
  for(i=0; i<16; i++)
    {
      node[96+i].x = i*80+40;
      node[96+i].y = 260;
    }

  // Connect duals
  for(i=0; i<4; i++)
    for(j=0; j<4; j++)
      {
	ConnectNodes(68+i*8,96+2*j);
	ConnectNodes(69+i*8,97+2*j);
	ConnectNodes(70+i*8,104+2*j);
	ConnectNodes(71+i*8,105+2*j);

      }
  for(i=0; i<4; i++)
    for(j=0; j<4; j++)
      {
	ConnectNodes(112+i*8,96+2*j);
	ConnectNodes(113+i*8,97+2*j);
	ConnectNodes(114+i*8,104+2*j);
	ConnectNodes(115+i*8,105+2*j);
      }

  Output();
}

*/

/*
// N = 64, BBW = 20 (5/8 full), D = 4

main()
{
  int i,j,k,l;

  numNodes = 96;
  node = (struct Node *)malloc(numNodes*sizeof(struct Node));

  for(i=0; i<numNodes; i++)
    Init(&node[i], i);

  OctSwitch(32);
  OctSwitch(40);
  OctSwitch(48);
  OctSwitch(56);

  // Place hosts and connect hosts to oct-switches
  for(i=0; i<16; i++)
    {
      node[i].x = i*30+30;
      node[i].y = 40;
      node[i].type = 1; // host
      node[i+16].x = i*30+520;
      node[i+16].y = 40;
      node[i+16].type = 1; // host

      node[i+64].x = i*30+30;
      node[i+64].y = 500;
      node[i+64].type = 1; // host
      node[i+80].x = i*30+520;
      node[i+80].y = 500;
      node[i+80].type = 1; // host

      ConnectNodes(i,(i/4)+32);
      ConnectNodes(i+16,(i/4)+40);

      ConnectNodes(i+64,(i/4)+52);
      ConnectNodes(i+80,(i/4)+60);
    }
  // Place oct-switches
  for(i=0; i<4; i++)
    {
      node[i+32].x = i*120+80;
      node[i+32].y = 100;
      node[i+40].x = i*120+560;
      node[i+40].y = 100;
      node[i+36].x = i*120+80;
      node[i+36].y = 200;
      node[i+44].x = i*120+560;
      node[i+44].y = 200;

      node[i+48].x = i*120+80;
      node[i+48].y = 340;
      node[i+56].x = i*120+560;
      node[i+56].y = 340;
      node[i+52].x = i*120+80;
      node[i+52].y = 440;
      node[i+60].x = i*120+560;
      node[i+60].y = 440;
    }

  // Straight links
  for(i=0; i<2; i++)
    for(j=0; j<3; j++)
      {
	ConnectNodes(36+i,48+i);
	ConnectNodes(47-i,59-i);
      }
  // Bent links
  for(i=0; i<2; i++)
    for(j=0; j<2; j++)
      {
	ConnectNodes(36+i+2*j,56+i+2*j);
	ConnectNodes(47-i-2*j,51-i-2*j);
      }
  for(i=0; i<2; i++)
    for(j=0; j<3; j++)
      {
	ConnectNodes(38+i,44+i);
	ConnectNodes(50+i,56+i);
      }

  Output();
}
*/

/*

N = 64, BBW = 32, D = 5

main()
{
  int i,j,k,l;

  node = (struct Node *)malloc(104*sizeof(struct Node));
  numNodes = 104;

  for(i=0; i<numNodes; i++)
    Init(&node[i], i);

  OctSwitch(32);
  OctSwitch(40);
  OctSwitch(56);
  OctSwitch(64);

  // Place hosts and connect hosts to oct-switches
  for(i=0; i<16; i++)
    {
      node[i].x = i*30+30;
      node[i].y = 40;
      node[i].type = 1; // host
      node[i+16].x = i*30+520;
      node[i+16].y = 40;
      node[i+16].type = 1; // host

      node[i+72].x = i*30+30;
      node[i+72].y = 600;
      node[i+72].type = 1; // host
      node[i+88].x = i*30+520;
      node[i+88].y = 600;
      node[i+88].type = 1; // host

      ConnectNodes(i,(i/4)+32);
      ConnectNodes(i+16,(i/4)+40);

      ConnectNodes(i+72,(i/4)+60);
      ConnectNodes(i+88,(i/4)+68);
    }
  // Place oct-switches
  for(i=0; i<4; i++)
    {
      node[i+32].x = i*120+80;
      node[i+32].y = 100;
      node[i+40].x = i*120+560;
      node[i+40].y = 100;
      node[i+36].x = i*120+80;
      node[i+36].y = 200;
      node[i+44].x = i*120+560;
      node[i+44].y = 200;

      node[i+56].x = i*120+80;
      node[i+56].y = 400;
      node[i+64].x = i*120+560;
      node[i+64].y = 400;
      node[i+60].x = i*120+80;
      node[i+60].y = 500;
      node[i+68].x = i*120+560;
      node[i+68].y = 500;
    }
  // Place dual-sw8's
  for(i=0; i<8; i++)
    {
      node[i+48].x = i*120+80;
      node[i+48].y = 300;
    }

  // Connect all to dual-sw8's
  for(l=0; l<40; l+=20)
    for(k=0; k<16; k+=8)
      for(i=0; i<2; i++)
	for(j=0; j<2; j++)
	  {
	    ConnectNodes(36+i+2*j+k+l,48+i+4*j);
	    ConnectNodes(36+i+2*j+k+l,48+i+4*j);
	    ConnectNodes(36+i+2*j+k+l,50+i+4*j);
	    ConnectNodes(36+i+2*j+k+l,50+i+4*j);
	  }

  Output();
}

*/

/*

N = 32, BBW = 16, D = 4

main()
{
  int i;

  node = new Node[48];
  numNodes = 48;

  for(i=0; i<numNodes; i++)
    Init(&node[i], i);

  OctSwitch(16);
  OctSwitch(24);

  // Place hosts and connect hosts to oct-switches
  for(i=0; i<16; i++)
    {
      node[i].x = i*40+40;
      node[i].y = 40;
      node[i].type = 1; // host
      node[i+32].x = i*40+40;
      node[i+32].y = 340;
      node[i+32].type = 1; // host
      ConnectNodes(i,(i/4)+16);
      ConnectNodes(i+32,(i/4)+28);
    }
  // Place oct-switches
  for(i=0; i<4; i++)
    {
      node[i+16].x = i*160+80;
      node[i+16].y = 100;
      node[i+20].x = i*160+80;
      node[i+20].y = 160;
      node[i+24].x = i*160+80;
      node[i+24].y = 220;
      node[i+28].x = i*160+80;
      node[i+28].y = 280;
    }
  // Connect two oct-switches together
  for(i=0; i<4; i++)
  {
    ConnectNodes(20+i,24+(i/2)*2);
    ConnectNodes(20+i,24+(i/2)*2);
    ConnectNodes(20+i,24+(i/2)*2+1);
    ConnectNodes(20+i,24+(i/2)*2+1);
  }

  Output();
}

*/
