#include <math.h>

#include "mapgen.c"

// Regular chordic graph

main()
{
  int i,j;
  int chord;
  int ho; // host offset
  int rack = 4;
  int radius;
  int phase;

  fprintf(stderr,"Enter the number of switches:\n");
  scanf("%d",&numSwitches);
  fprintf(stderr,"Enter the length of the chord:\n");
  scanf("%d",&chord);

  numHosts = numSwitches * rack;

  numDeadSwitches = 0;
  numDeadHosts = 0;

  numNodes = numSwitches + numHosts;
  node = (struct Node *)malloc(numNodes*sizeof(struct Node));
  for(i=0; i<numNodes; i++)
    Init(&node[i], i);

  ho = numSwitches;

  radius = numSwitches * 15;

  for(i=0; i<numSwitches; i++)
  {
    node[i].number = i;
    
    node[i].x = cos(i*6.2832/numSwitches)*radius + radius + 60;
    node[i].y = sin(i*6.2832/numSwitches)*radius + radius + 60;
    node[i].ports = 8;

    sprintf(node[i].name,"s%d",i);

    ConnectNodes(i,(i+1)%numSwitches);
    ConnectNodes(i,(i+chord)%numSwitches);
  }
  for(i=0; i<numHosts; i++)
  {
    node[ho+i].type = 1; // host
    node[ho+i].x = cos((i-2)*6.2832/numHosts)*(radius+50)
      + radius + 60;
    node[ho+i].y = sin((i-2)*6.2832/numHosts)*(radius+50)
      + radius + 60;

    sprintf(node[ho+i].name,"h%d-%d",i/rack,i%rack);

    ConnectNodes(ho+i,i/rack);
  }

  // Number edges

  phase = 0;

  for(i=0; i<numSwitches; i++)
    NumberEdge(i*chord,((i+1)*chord));

  for(i=0; i<numSwitches; i++)
    NumberEdge(-i*chord+phase,(-(i+1)*chord)+phase);

  for(i=0; i<numSwitches; i++)
    NumberEdge(i,i+1);

  for(i=0; i<numSwitches; i++)
    NumberEdge(-i+phase,-(i+1)+phase);

  Output();
}
