/*
  sm_Switch.c
  map tools
  finucane@myri.com (David Finucane)
*/

#include <string.h>

#include "insist.h"
#include "sm_Switch.h"

int sm_Switch::numSwitches = 0;

sm_Switch::sm_Switch (char*name, char*type, int inSize, int outSize, int timeForByte) : sm_Node (name, type)
{
  for (int i = 0; i < NUM_PORTS; i++)
    makePort (i, inSize, outSize, timeForByte);
  id = ++numSwitches;
}


int sm_Switch::getId ()
{
  insist (this);
  return id;
  exception: return 0;
}


int sm_Switch::definePorts (char*s)
{
  insist (this);

  int len;
  len = strlen (s);
  insistp (len <= NUM_PORTS, ("sm_Switch::definePorts: ports string too long"));
  
  for (int i = 0; i < len; i++)
  {
    insistp (s[i] == 's' || s[i] == 'l', ("sm_Switch::definePorts: bad port char"));
    if (s[i] == 'l')
      definePort (i, 100, 10, sm_Node::TIME_FOR_BYTE);
    else if (s[i] == 's')
      definePort (i, 4, 4, sm_Node::TIME_FOR_BYTE);
  }
  
  return 1;
  exception: return 0;
}

int sm_Switch::isNull ()
{
  return 0;
}

int sm_Switch::getNodeType ()
{
  return mt_Node::SWITCH;
}

int sm_Switch::getMaxNodes ()
{
  insist (this);
  return NUM_PORTS;
  exception: return 0;
}


int sm_Switch::setOption (char*option, char*value)
{
  insist (option && value);

  if (sm_Node::setOption (option, value))
    return 1;
  
  if (!strcmp (option, "ports"))
    return definePorts (value);

  return 1;

  exception: return 0;
}


sm_Port*sm_Switch::getInput (int p)
{
  insist (p >=0 && p < NUM_PORTS);
  return &inputs[p];
  exception: return 0;
}

sm_Port*sm_Switch::getOutput (int p)
{
  if (p >=0 && p < NUM_PORTS)
    return &outputs[p];
  else return 0;
}

void sm_Switch::makePort (int p, int inSize, int outSize, int timeForByte)
{
  insist (p >=0 && p < NUM_PORTS);
  insist (inSize > 0 && outSize > 0);

  inputs [p] = sm_Port (this, p, inSize, 0, timeForByte);
  outputs[p] = sm_Port (this, p, outSize, 0, timeForByte);
  exception: return;
}

void sm_Switch::definePort (int p, int inSize, int outSize, int timeForByte)
{
  insist (p >=0 && p < NUM_PORTS);
  insist (inSize > 0 && outSize > 0);

  inputs [p].define (inSize, 0, timeForByte);
  outputs[p].define (outSize, 0, timeForByte);
  exception: return;
}

void sm_Switch::call (sm_EventList*, int, long)
{
}
