/*
  mt_Simulator.h
  map tools
  finucane@myri.com (David Finucane)
*/

#include <time.h>
#ifndef mt_Simulator_h
#define mt_Simulator_h

#include "mt_Queue.h"
#include "mt_Simulation.h"
#include "mt_Network.h"
#include "mt_RouteTable.h"
#include "mt_Calculator.h"
#include "mt_Module.h"
#include "sm_Graph.h"
#include "sm_Packet.h"
#include "sm_EventList.h"

class sm_Simulator : public mt_Network
{
  private:
  time_t startTime;
  mt_Calculator*calculator;
  mt_Job*waitJob;
  char*waitData;
  int waitLength;
  int waitEvent;
  volatile int waiting;
  int letPacketsDie;
  int randomSeed;
  int hostDropPeriod;
  int eschewRoutes;
  int hostDelay;
  int hostDropCount;
  int hostDropType;
  int switchInSize;
  int switchOutSize;
  int switchTimeForByte;
  int shortOutput;
  
  mt_Queue nullList;
  mt_Simulation*simulation;
  sm_Graph*graph;
  sm_EventList*list;
  mt_RouteTable*routes;
  int maxPackets;
  int queueLatency;
  int queueSize;
  char outFile [mt_File::FILENAME_LENGTH + 1];
  char routeFile [mt_File::FILENAME_LENGTH + 1];
  char mapFile [mt_File::FILENAME_LENGTH + 1];
  sm_Time latencyTotal;
  int latencyNumPackets;
  
  int addNulls (mt_Graph*graph);
  int startJobs ();

  sm_Packet *deadlockedPacket;

  public:
  int checkForDeadlocks;
  
  sm_Simulator ();
  virtual ~sm_Simulator ();

  void abortWithDeadlock(sm_Packet *deadlockedPacket);

  void simpleDump (FILE *outFile);

  int getMaxPackets ();
  int getNumReceived ();
  int getEventQueueSize ();
  double getUtilization();
  int getAverageLatency();
  void addLatency(int latency);
  int step (int numEvents);
  int waitNotify (mt_Job*job, int event, char*p, int length);
  int getLetPacketsDie ();
  int inspectQueue (char*s);
  int getHostDropPeriod ();
  int getHostDelay ();
  int getHostDropCount ();
  int getHostDropType ();
  
  virtual int parseArgs (mt_Args*args);

  virtual void usage ();
  virtual int initialize (mt_Calculator*calculator, mt_Simulation*simulation);
  virtual void cleanup ();

  virtual void dump ();
  virtual void run ();
  virtual int wait (char**p, int*length);
  virtual void freePacket (char*p);

  virtual mt_Graph*getGraph ();
  virtual int getRoute (int from, int to, int index, mt_Route*route);
  virtual int getNumRoutes (int from, int to);
  virtual int open (mt_Job*job, mt_Address*address, char*hostname, int*type, int unit, int numReceiveBuffers);
  virtual void close (mt_Job*job);
  virtual int send (mt_Job*job, mt_Route*route, char*p, int length);
  virtual int sendWithPadding (mt_Job*job, mt_Route*route, char*p, int length, int totalLength);
  virtual void setTimer (mt_Job*job, int microseconds);
  virtual void clearTimer (mt_Job*job);
  virtual void setRoute (mt_Job*job, int gmId, mt_Route*route);
  virtual void setAddress (mt_Job*job, int gmId, mt_Address*address);
  virtual void setHostname (mt_Job*job, int gmId, char*hostname);
  virtual void setGmId (mt_Job*job, int gmId);
  virtual int getGmId (mt_Job*job);
  virtual void setLevel (mt_Job*job, int level);
  virtual mt_Int64 getCurrentTime ();
  virtual void clearRoutes (mt_Job*job);
  virtual int getNumReceiveBuffers ();
  virtual int getReceiveMtu ();
};

#endif /*sm_Simulator_h*/
