/*
  sm_Port.h
  map tools
  finucane@myri.com (David Finucane)
*/


#ifndef sm_Port_h
#define sm_Port_h

#include "sm_Callable.h"
#include "sm_EventList.h"
#include "mt_Node.h"

class sm_Node;
class sm_Packet;

class sm_Port : public mt_Component, public sm_Callable
{
  private:
  int size;
  int port;
  int numPackets;
  
  sm_Node*node;
  sm_Packet*packet;
  sm_Port*next;
  int latency;
  sm_Time timeUtilized;
  int timeForByte;
  sm_Packet*nextInLine;
  
  public:
  sm_Packet*head;
  sm_Packet*tail;
  
  sm_Port ();
  sm_Port (sm_Node*node, int port, int size, int latency, int timeForByte);  
  void define (int size, int latency, int timeForByte);
  void setNextInLine (sm_Packet*nextInLine);
  sm_Packet* getNextInLine ();
  int getTimeForByte ();
  int getAddedLatency ();
  void setNext (sm_Port*next);
  sm_Port*getNext ();
  void setPacket (sm_Packet*packet);
  sm_Packet*getPacket ();
  int getSize ();
  int getPort ();
  sm_Node*getNode ();
  sm_Time getTimeUtilized ();
  int getNumPackets ();
  virtual void call (sm_EventList*list, int type, long data);
};

#endif
