/*
  sm_Packet.h
  map tools
  finucane@myri.com (David Finucane)
*/

#ifndef sm_Packet_h
#define sm_Packet_h

#include <stdio.h>

#include "mt_Route.h"
#include "sm_Port.h"

class sm_Host;

class sm_Packet : public mt_Component, public sm_Callable, public mt_Queueable
{
  private:
  enum
  {
    MAX_LENGTH = 4 * sizeof (int),
    UNMARKED = 0,
    DEADLOCK_MARK = 1,
    PRINT_MARK = 2,
  };
  
  char bytes [mt_Route::MAX_ROUTE];
  char buffer [MAX_LENGTH];
  char*myMessage;
  char*message;
  int messageLength;
  int letMeDie;
  int dead;
  int byteLength;
  int byteIndex;
  int length;
  sm_Port*headPort;
  sm_Port*tailPort;
  sm_Port*oldTail;
  int headPosition;
  int tailPosition;
  double tailFragment;
  double headFragment;
  int lastTimeForHeadByte;
  int lastTimeForTailByte;
  sm_Packet*next;
  sm_Packet*prev;
  int latency;
  int mostTimeForByte;
  sm_Time startTime;
  sm_Time lastTime;
  int blocked;
  int id;
  static int numReceived;
  static int numSent;
  sm_Host *sourceHost;
  int mark;
  
  public:
  sm_Packet (mt_Route*route, char*p, int length, int extraLength, sm_Time startTime, int letMeDie);
  virtual ~sm_Packet ();
  
  static int getNumReceived ();
  static int getNumSent ();
  static void clearCounters ();
  int getMark ();
  void setMark (int mark);
  
  void dumpChain (FILE*fp);
  void dump (FILE *fp);

  char*getMessage ();
  int getMessageLength ();

  int isGoodForHost ();
  int canDie ();
  void removeBlocked (sm_EventList*list,sm_Port*p);
  int addBlocked (sm_EventList*list, sm_Port*p);
  int slamIntoNext (sm_EventList*list, int td);
  int slamIntoEnd (sm_EventList*list, int td);
  int cross (sm_EventList*list);
  int inch (sm_EventList*list, int td, int ttb);
  void received(sm_Time when);
  void reschedule (sm_EventList*list);  
  int rescheduleTheDead (sm_EventList*list);  
  void update (sm_EventList*list);
  int getMostTimeForByte ();
  int getLatency ();
  void setSpeed (int timeForByte);
  inline int getTimeForHeadByte ();
  inline int getTimeForTailByte ();
  int getId ();
  sm_Port*getNextPort ();
  int isBlocked (sm_Port*p);
  int getTailPosition ();
  void setHeadPort (sm_Port*p);
  void setTailPort (sm_Port*p);
  int getLength ();
  sm_Port*getHeadPort ();
  sm_Port*getTailPort ();
  void setHeadPosition (int p);
  void setTailPosition (int p);
  void setStartTime (sm_Time time);
  sm_Time getStartTime ();
  int isDeadlocked ();
  virtual void call (sm_EventList*list, int type, long data);
};


inline int sm_Packet::getTimeForHeadByte ()
{
  
  if (next)
    return next->getTimeForTailByte ();
  return headPort->getTimeForByte ();
}

inline int sm_Packet::getTimeForTailByte ()
{
  int ttb;
  ttb = 0;
  sm_Port*p;
  for (p = tailPort; p; p = p->getNext ())
  {
    int t = p->getTimeForByte ();
      
    if (t > ttb)
      ttb = t;
    if (p == headPort)
      break;
  }
  if (dead) return ttb;
  
  int thb;
  thb = getTimeForHeadByte ();
  return thb > ttb ? thb : ttb;
}

#endif /*sm_Packet_h*/
